/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper;

import java.util.Collections;
import java.util.Iterator;
import org.threadly.util.ArrayIterator;
import org.threadly.util.ExceptionUtils;

public class RunnableChain
implements Runnable {
    protected final boolean exceptionStopsChain;
    private final Iterable<? extends Runnable> toRun;

    public RunnableChain(boolean exceptionStopsChain, Runnable ... runnables) {
        this(exceptionStopsChain, ArrayIterator.makeIterable(runnables));
    }

    public RunnableChain(boolean exceptionStopsChain, Iterable<? extends Runnable> toRun) {
        if (toRun == null) {
            toRun = Collections.emptyList();
        }
        this.exceptionStopsChain = exceptionStopsChain;
        this.toRun = toRun;
    }

    @Override
    public void run() {
        if (this.exceptionStopsChain) {
            this.runExceptionsCascade();
        } else {
            this.runIsolated();
        }
    }

    protected void runExceptionsCascade() {
        Iterator<? extends Runnable> it = this.toRun.iterator();
        while (it.hasNext()) {
            it.next().run();
        }
    }

    protected void runIsolated() {
        Iterator<? extends Runnable> it = this.toRun.iterator();
        while (it.hasNext()) {
            try {
                it.next().run();
            }
            catch (Throwable t) {
                ExceptionUtils.handleException(t);
            }
        }
    }
}

