/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.processing;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.threadly.concurrent.ReschedulingOperation;
import org.threadly.concurrent.SameThreadSubmitterExecutor;
import org.threadly.concurrent.future.FutureCallback;
import org.threadly.concurrent.future.FutureUtils;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.concurrent.future.SettableListenableFuture;
import org.threadly.util.ArgumentVerifier;

public abstract class FlowControlledProcessor<T> {
    protected final int maxRunningTasks;
    private final SettableListenableFuture<Void> completeFuture;
    private final ProcessingMonitor futureMonitor;
    private boolean started = false;

    public FlowControlledProcessor(int maxRunningTasks, boolean provideResultsInOrder) {
        ArgumentVerifier.assertGreaterThanZero(maxRunningTasks, "maxRunningTasks");
        this.maxRunningTasks = maxRunningTasks;
        this.completeFuture = new SettableListenableFuture(false);
        this.futureMonitor = provideResultsInOrder ? new InOrderProcessingMonitor() : new ProcessingMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<?> start() {
        FlowControlledProcessor flowControlledProcessor = this;
        synchronized (flowControlledProcessor) {
            if (this.started) {
                throw new IllegalStateException("Already started");
            }
            this.started = true;
        }
        this.futureMonitor.start();
        return this.completeFuture;
    }

    protected abstract boolean hasNext();

    protected abstract ListenableFuture<? extends T> next();

    protected abstract void handleResult(T var1);

    protected abstract boolean handleFailure(Throwable var1);

    protected class InOrderProcessingMonitor
    extends ProcessingMonitor {
        protected final ReschedulingOperation futureConsumer;
        protected Queue<ListenableFuture<? extends T>> futureQueue;

        protected InOrderProcessingMonitor() {
            this.futureConsumer = new ReschedulingOperation((Executor)SameThreadSubmitterExecutor.instance()){

                @Override
                protected void run() {
                    ListenableFuture lf;
                    while ((lf = this.nextReadyFuture()) != null) {
                        try {
                            Throwable failure = lf.getFailure();
                            if (failure != null) {
                                this.handleInOrderFailure(failure);
                                continue;
                            }
                            try {
                                FlowControlledProcessor.this.handleResult(lf.get());
                            }
                            catch (InterruptedException | ExecutionException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        catch (Throwable t) {
                            this.handleInOrderFailure(t);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected ListenableFuture<? extends T> nextReadyFuture() {
                    Queue queue = InOrderProcessingMonitor.this.futureQueue;
                    synchronized (queue) {
                        if (!InOrderProcessingMonitor.this.futureQueue.isEmpty() && InOrderProcessingMonitor.this.futureQueue.peek().isDone()) {
                            return InOrderProcessingMonitor.this.futureQueue.remove();
                        }
                    }
                    return null;
                }

                protected void handleInOrderFailure(Throwable t) {
                    if (!FlowControlledProcessor.this.handleFailure(t)) {
                        FlowControlledProcessor.this.completeFuture.setFailure(t);
                    }
                }
            };
            this.futureQueue = new ArrayDeque(FlowControlledProcessor.this.maxRunningTasks);
        }

        @Override
        public void handleResult(T result) {
            try {
                this.futureConsumer.signalToRun();
            }
            finally {
                this.readyForNext();
            }
        }

        @Override
        public void handleFailure(Throwable t) {
            try {
                this.futureConsumer.signalToRun();
            }
            finally {
                this.readyForNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected ListenableFuture<? extends T> next() {
            ListenableFuture result;
            try {
                result = FlowControlledProcessor.this.next();
            }
            catch (Throwable t) {
                result = FutureUtils.immediateFailureFuture(t);
            }
            Queue queue = this.futureQueue;
            synchronized (queue) {
                this.futureQueue.add(result);
            }
            return result;
        }
    }

    protected class ProcessingMonitor
    implements FutureCallback<T> {
        private int currentRunningTasks = 0;

        protected ProcessingMonitor() {
        }

        public void start() {
            ArrayList futures = new ArrayList(FlowControlledProcessor.this.maxRunningTasks);
            while (this.currentRunningTasks < FlowControlledProcessor.this.maxRunningTasks && !FlowControlledProcessor.this.completeFuture.isDone() && FlowControlledProcessor.this.hasNext()) {
                ++this.currentRunningTasks;
                try {
                    futures.add(this.next());
                }
                catch (Exception e) {
                    this.handleFailure(e);
                }
            }
            if (this.currentRunningTasks == 0) {
                FlowControlledProcessor.this.completeFuture.setResult(null);
            } else {
                for (ListenableFuture listenableFuture : futures) {
                    listenableFuture.callback(this);
                }
            }
        }

        protected ListenableFuture<? extends T> next() {
            return FlowControlledProcessor.this.next();
        }

        @Override
        public void handleResult(T result) {
            try {
                FlowControlledProcessor.this.handleResult(result);
                this.readyForNext();
            }
            catch (Throwable t) {
                this.handleFailure(t);
            }
        }

        @Override
        public void handleFailure(Throwable t) {
            if (FlowControlledProcessor.this.handleFailure(t)) {
                this.readyForNext();
            } else {
                FlowControlledProcessor.this.completeFuture.setFailure(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void readyForNext() {
            ListenableFuture nextFuture;
            FlowControlledProcessor flowControlledProcessor = FlowControlledProcessor.this;
            synchronized (flowControlledProcessor) {
                try {
                    if (FlowControlledProcessor.this.completeFuture.isDone() || !FlowControlledProcessor.this.hasNext()) {
                        --this.currentRunningTasks;
                        if (this.currentRunningTasks == 0) {
                            FlowControlledProcessor.this.completeFuture.setResult(null);
                        }
                        return;
                    }
                    nextFuture = this.next();
                }
                catch (Throwable t) {
                    this.handleFailure(t);
                    return;
                }
            }
            nextFuture.callback(this);
        }
    }
}

