/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.future;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.threadly.concurrent.CallableContainer;
import org.threadly.concurrent.RunnableCallableAdapter;
import org.threadly.concurrent.future.AbstractCompletableListenableFuture;
import org.threadly.concurrent.future.ListenableRunnableFuture;

public class ListenableFutureTask<T>
extends AbstractCompletableListenableFuture<T>
implements ListenableRunnableFuture<T>,
CallableContainer<T> {
    private static final VarHandle EXEC_THREAD;
    protected Callable<T> callable;

    public ListenableFutureTask(Runnable task) {
        this(task, null, null);
    }

    public ListenableFutureTask(Runnable task, T result) {
        this(task, result, null);
    }

    public ListenableFutureTask(Callable<T> task) {
        this(task, null);
    }

    public ListenableFutureTask(Runnable task, T result, Executor executingExecutor) {
        this(RunnableCallableAdapter.adapt(task, result), executingExecutor);
    }

    public ListenableFutureTask(Callable<T> task, Executor executingExecutor) {
        super(executingExecutor);
        this.callable = task;
    }

    @Override
    protected void handleCompleteState() {
        this.callable = null;
    }

    @Override
    public void run() {
        if (this.state != 0 || !EXEC_THREAD.compareAndSet(this, null, Thread.currentThread())) {
            return;
        }
        try {
            Callable<T> c = this.callable;
            if (c != null && this.state == 0) {
                this.completeWithResult(c.call());
            }
        }
        catch (Throwable t) {
            this.completeWithFailure(t);
        }
        finally {
            while (this.state == 5) {
                Thread.yield();
            }
            this.execThread = null;
        }
    }

    @Override
    public Callable<T> getContainedCallable() {
        return this.callable;
    }

    @Override
    public String toString() {
        return super.toString(this.callable);
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            EXEC_THREAD = l.findVarHandle(AbstractCompletableListenableFuture.class, "execThread", Thread.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

