/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.future;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.threadly.concurrent.SameThreadSubmitterExecutor;
import org.threadly.concurrent.future.FutureCallback;
import org.threadly.concurrent.future.FutureUtils;
import org.threadly.concurrent.future.ImmediateFailureListenableFuture;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.concurrent.future.ListenableFutureTask;
import org.threadly.concurrent.future.SettableListenableFuture;
import org.threadly.util.ExceptionUtils;
import org.threadly.util.StackSuppressedRuntimeException;

class InternalFutureUtils {
    protected static final String NULL_FUTURE_MAP_RESULT_ERROR_PREFIX = "ListenableFuture flatMap mapper returned null (need future): ";

    InternalFutureUtils() {
    }

    protected static boolean invokeCompletedDirectly(Executor executor, ListenableFuture.ListenerOptimizationStrategy optimize) {
        return executor == null || optimize == ListenableFuture.ListenerOptimizationStrategy.InvokingThreadIfDone | optimize == ListenableFuture.ListenerOptimizationStrategy.SingleThreadIfExecutorMatchOrDone;
    }

    protected static <ST, RT> ListenableFuture<RT> transform(ListenableFuture<ST> sourceFuture, final Function<? super ST, ? extends RT> mapper, final boolean reportedTransformedExceptions, Executor executor, ListenableFuture.ListenerOptimizationStrategy optimizeExecution) {
        if (sourceFuture.isDone()) {
            Object sourceResult;
            if (sourceFuture.isCompletedExceptionally()) {
                return sourceFuture;
            }
            try {
                sourceResult = sourceFuture.get();
            }
            catch (Exception e) {
                ExceptionUtils.handleException(e);
                return FutureUtils.immediateFailureFuture(e);
            }
            if (InternalFutureUtils.invokeCompletedDirectly(executor, optimizeExecution)) {
                try {
                    return FutureUtils.immediateResultFuture(mapper.apply(sourceResult));
                }
                catch (Throwable t) {
                    if (reportedTransformedExceptions) {
                        ExceptionUtils.handleException(t);
                    }
                    return FutureUtils.immediateFailureFuture(t);
                }
            }
            ListenableFutureTask<Object> futureTask = new ListenableFutureTask<Object>(() -> {
                try {
                    return mapper.apply(sourceResult);
                }
                catch (Throwable t) {
                    if (reportedTransformedExceptions) {
                        ExceptionUtils.handleException(t);
                    }
                    throw t;
                }
            }, executor);
            executor.execute(futureTask);
            return futureTask;
        }
        final CancelDelegateSettableListenableFuture slf = new CancelDelegateSettableListenableFuture(sourceFuture, executor);
        sourceFuture.callback(new FailurePropogatingFutureCallback<ST>(slf){

            @Override
            public void handleResult(ST result) {
                try {
                    slf.setRunningThread(Thread.currentThread());
                    slf.completeWithResult(mapper.apply(result));
                }
                catch (Throwable t) {
                    if (reportedTransformedExceptions) {
                        ExceptionUtils.handleException(t);
                    }
                    slf.completeWithFailure(t);
                }
            }
        }, executor, optimizeExecution);
        return slf;
    }

    protected static <ST, RT> ListenableFuture<RT> flatTransform(ListenableFuture<? extends ST> sourceFuture, final Function<? super ST, ListenableFuture<RT>> mapper, Executor executor, ListenableFuture.ListenerOptimizationStrategy optimizeExecution) {
        if (sourceFuture.isDone()) {
            if (sourceFuture.isCompletedExceptionally()) {
                return sourceFuture;
            }
            if (InternalFutureUtils.invokeCompletedDirectly(executor, optimizeExecution)) {
                try {
                    ListenableFuture<RT> result = mapper.apply(sourceFuture.get());
                    if (result == null) {
                        return FutureUtils.immediateFailureFuture(new NullPointerException(NULL_FUTURE_MAP_RESULT_ERROR_PREFIX + mapper));
                    }
                    return result;
                }
                catch (Throwable t) {
                    ExceptionUtils.handleException(t);
                    return FutureUtils.immediateFailureFuture(t);
                }
            }
        }
        final CancelDelegateSettableListenableFuture slf = new CancelDelegateSettableListenableFuture(sourceFuture, executor);
        sourceFuture.callback(new FailurePropogatingFutureCallback<ST>(slf){

            @Override
            public void handleResult(ST result) {
                try {
                    slf.setRunningThread(Thread.currentThread());
                    ListenableFuture mapFuture = (ListenableFuture)mapper.apply(result);
                    if (mapFuture == null) {
                        slf.completeWithFailure(new NullPointerException(InternalFutureUtils.NULL_FUTURE_MAP_RESULT_ERROR_PREFIX + mapper));
                        return;
                    }
                    slf.updateDelegateFuture(mapFuture);
                    mapFuture.callback(slf, null, null);
                    slf.setRunningThread(null);
                }
                catch (Throwable t) {
                    ExceptionUtils.handleException(t);
                    slf.completeWithFailure(t);
                }
            }
        }, executor, optimizeExecution);
        return slf;
    }

    protected static <TT extends Throwable, RT> ListenableFuture<RT> failureTransform(ListenableFuture<RT> sourceFuture, Supplier<String> cancelationMessageSupplier, final Function<? super TT, ? extends RT> mapper, final Class<TT> throwableType, Executor executor, ListenableFuture.ListenerOptimizationStrategy optimizeExecution) {
        if (sourceFuture.isDone()) {
            Object cause = InternalFutureUtils.extractThrowableFromDoneFuture(sourceFuture, cancelationMessageSupplier, throwableType);
            if (cause == null) {
                return sourceFuture;
            }
            if (InternalFutureUtils.invokeCompletedDirectly(executor, optimizeExecution)) {
                try {
                    return FutureUtils.immediateResultFuture(mapper.apply(cause));
                }
                catch (Throwable t) {
                    return FutureUtils.immediateFailureFuture(t);
                }
            }
            ListenableFutureTask<Object> futureTask = new ListenableFutureTask<Object>(() -> mapper.apply(cause), executor);
            executor.execute(futureTask);
            return futureTask;
        }
        final CancelDelegateSettableListenableFuture slf = new CancelDelegateSettableListenableFuture(sourceFuture, executor);
        sourceFuture.callback(new FutureCallback<RT>(){

            @Override
            public void handleResult(RT result) {
                slf.completeWithResult(result);
            }

            @Override
            public void handleFailure(Throwable t) {
                if (throwableType == null || throwableType.isAssignableFrom(t.getClass())) {
                    try {
                        slf.setRunningThread(Thread.currentThread());
                        slf.completeWithResult(mapper.apply(t));
                    }
                    catch (Throwable newT) {
                        slf.completeWithFailure(newT);
                    }
                } else {
                    slf.completeWithFailure(t);
                }
            }
        }, executor, optimizeExecution);
        return slf;
    }

    protected static <TT extends Throwable, RT> ListenableFuture<RT> flatFailureTransform(ListenableFuture<RT> sourceFuture, Supplier<String> cancelationMessageSupplier, final Function<? super TT, ListenableFuture<RT>> mapper, final Class<TT> throwableType, Executor executor, ListenableFuture.ListenerOptimizationStrategy optimizeExecution) {
        if (sourceFuture.isDone()) {
            TT cause = InternalFutureUtils.extractThrowableFromDoneFuture(sourceFuture, cancelationMessageSupplier, throwableType);
            if (cause == null) {
                return sourceFuture;
            }
            if (InternalFutureUtils.invokeCompletedDirectly(executor, optimizeExecution)) {
                try {
                    ListenableFuture<RT> result = mapper.apply(cause);
                    if (result == null) {
                        return FutureUtils.immediateFailureFuture(new NullPointerException(NULL_FUTURE_MAP_RESULT_ERROR_PREFIX + mapper));
                    }
                    return result;
                }
                catch (Throwable t) {
                    return FutureUtils.immediateFailureFuture(t);
                }
            }
            if (sourceFuture.isCancelled()) {
                sourceFuture = new ImmediateFailureListenableFuture<RT>((Throwable)cause);
            }
        }
        final CancelDelegateSettableListenableFuture slf = new CancelDelegateSettableListenableFuture(sourceFuture, executor);
        sourceFuture.callback(new FutureCallback<RT>(){

            @Override
            public void handleResult(RT result) {
                slf.completeWithResult(result);
            }

            @Override
            public void handleFailure(Throwable t) {
                if (throwableType == null || throwableType.isAssignableFrom(t.getClass())) {
                    try {
                        slf.setRunningThread(Thread.currentThread());
                        ListenableFuture mapFuture = (ListenableFuture)mapper.apply(t);
                        if (mapFuture == null) {
                            slf.completeWithFailure(new NullPointerException(InternalFutureUtils.NULL_FUTURE_MAP_RESULT_ERROR_PREFIX + mapper));
                            return;
                        }
                        slf.updateDelegateFuture(mapFuture);
                        mapFuture.callback(slf, null, null);
                        slf.setRunningThread(null);
                    }
                    catch (Throwable newT) {
                        slf.completeWithFailure(newT);
                    }
                } else {
                    slf.completeWithFailure(t);
                }
            }
        }, executor, optimizeExecution);
        return slf;
    }

    private static <TT extends Throwable> TT extractThrowableFromDoneFuture(ListenableFuture<?> sourceFuture, Supplier<String> cancelationMessageSupplier, Class<TT> throwableType) {
        try {
            if (sourceFuture.isCancelled()) {
                if (throwableType == null || throwableType.isAssignableFrom(CancellationException.class)) {
                    String msg = cancelationMessageSupplier == null ? null : cancelationMessageSupplier.get();
                    return (TT)new CancellationException(msg);
                }
                return null;
            }
            Throwable cause = sourceFuture.getFailure();
            if (cause != null && (throwableType == null || throwableType.isAssignableFrom(cause.getClass()))) {
                return (TT)cause;
            }
            return null;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected static class CancelOnErrorFutureCallback
    implements Consumer<Throwable> {
        private static final VarHandle CANCELED;
        private final Iterable<? extends ListenableFuture<?>> futures;
        private final boolean interruptThread;
        private boolean canceled;

        public CancelOnErrorFutureCallback(Iterable<? extends ListenableFuture<?>> futures, boolean interruptThread) {
            this.futures = futures;
            this.interruptThread = interruptThread;
        }

        @Override
        public void accept(Throwable t) {
            if (!this.canceled && CANCELED.compareAndSet(this, false, true)) {
                FutureUtils.cancelIncompleteFutures(this.futures, this.interruptThread);
            }
        }

        static {
            try {
                CANCELED = MethodHandles.lookup().findVarHandle(CancelOnErrorFutureCallback.class, "canceled", Boolean.TYPE);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected static final class FailureFutureCollection<T>
    extends PartialFutureCollection<T> {
        protected FailureFutureCollection(Iterator<? extends ListenableFuture<? extends T>> source) {
            super(source);
        }

        @Override
        protected void init(int futureCount) {
        }

        @Override
        protected void handleFutureDone(ListenableFuture<? extends T> f, int index) {
            if (f.isCompletedExceptionally()) {
                this.addResult(f, index);
            }
        }
    }

    protected static final class SuccessFutureCollection<T>
    extends PartialFutureCollection<T> {
        protected SuccessFutureCollection(Iterator<? extends ListenableFuture<? extends T>> source) {
            super(source);
        }

        @Override
        protected void handleFutureDone(ListenableFuture<? extends T> f, int index) {
            if (!f.isCompletedExceptionally()) {
                this.addResult(f, index);
            }
        }
    }

    protected static abstract class PartialFutureCollection<T>
    extends FutureCollection<T> {
        protected PartialFutureCollection(Iterator<? extends ListenableFuture<? extends T>> source) {
            super(source);
        }

        @Override
        protected List<ListenableFuture<? extends T>> getFinalResultList() {
            List<ListenableFuture<T>> superResult = super.getFinalResultList();
            for (int i = 0; i < superResult.size(); ++i) {
                if (superResult.get(i) != null) continue;
                int n = i = i == 0 ? 1 : 0;
                while (i < superResult.size()) {
                    if (superResult.get(i) != null) {
                        ArrayList<ListenableFuture<T>> result = new ArrayList<ListenableFuture<T>>(superResult.size() - Math.max(i, 1));
                        while (i < superResult.size()) {
                            ListenableFuture<? extends T> lf = superResult.get(i);
                            if (lf != null) {
                                result.add(lf);
                            }
                            ++i;
                        }
                        return result;
                    }
                    ++i;
                }
                return Collections.emptyList();
            }
            return superResult;
        }
    }

    protected static final class AllFutureCollection<T>
    extends FutureCollection<T> {
        protected AllFutureCollection(Iterator<? extends ListenableFuture<? extends T>> source) {
            super(source);
        }

        @Override
        protected void handleFutureDone(ListenableFuture<? extends T> f, int index) {
            this.addResult(f, index);
        }
    }

    protected static final class EmptyFutureCollection
    extends FutureCollection<Object> {
        private Runnable doneTaskSingleton;

        protected EmptyFutureCollection(Iterator<? extends ListenableFuture<?>> source) {
            super(source);
        }

        @Override
        protected void init(int futureCount) {
        }

        @Override
        protected void handleFutureDone(ListenableFuture<?> f, int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected List<ListenableFuture<?>> getFinalResultList() {
            return null;
        }

        @Override
        protected void attachFutureDoneTask(ListenableFuture<?> f, int index) {
            if (this.doneTaskSingleton == null) {
                this.doneTaskSingleton = () -> {
                    if (this.remainingResult.decrementAndGet() == 0) {
                        this.completeWithResult(this.getFinalResultList());
                    }
                };
            }
            f.listener(this.doneTaskSingleton, SameThreadSubmitterExecutor.instance());
        }
    }

    protected static abstract class FutureCollection<T>
    extends SettableListenableFuture<List<ListenableFuture<? extends T>>> {
        private static final ListenableFuture[] EMPTY_ARRAY = new ListenableFuture[0];
        protected final AtomicInteger remainingResult = new AtomicInteger(0);
        private ArrayList<ListenableFuture<? extends T>> futures = new ArrayList();
        protected ListenableFuture<? extends T>[] buildingResult = EMPTY_ARRAY;

        protected FutureCollection(Iterator<? extends ListenableFuture<? extends T>> it) {
            super(false);
            int count = 0;
            while (it.hasNext()) {
                ListenableFuture<? extends T> f = it.next();
                this.futures.add(f);
                this.attachFutureDoneTask(f, count++);
            }
            this.init(count);
            if (this.remainingResult.addAndGet(count) == 0) {
                this.completeWithResult(this.getFinalResultList());
            } else {
                this.futures.trimToSize();
            }
        }

        @Override
        protected void handleCompleteState() {
            this.futures = null;
            super.handleCompleteState();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void init(int futureCount) {
            FutureCollection futureCollection = this;
            synchronized (futureCollection) {
                this.ensureCapacity(futureCount);
            }
        }

        protected ListenableFuture<? extends T>[] ensureCapacity(int capacity) {
            if (this.buildingResult.length < capacity) {
                this.buildingResult = Arrays.copyOf(this.buildingResult, capacity);
            }
            return this.buildingResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addResult(ListenableFuture<? extends T> f, int index) {
            FutureCollection futureCollection = this;
            synchronized (futureCollection) {
                this.ensureCapacity((int)(index + 1))[index] = f;
            }
        }

        protected void attachFutureDoneTask(ListenableFuture<? extends T> f, int index) {
            f.listener(new FutureDoneTask(f, index), SameThreadSubmitterExecutor.instance());
        }

        @Override
        public boolean cancel(boolean interrupt) {
            ArrayList<ListenableFuture<? extends T>> futures = this.futures;
            if (super.cancel(interrupt)) {
                FutureUtils.cancelIncompleteFutures(futures, interrupt);
                return true;
            }
            return false;
        }

        protected abstract void handleFutureDone(ListenableFuture<? extends T> var1, int var2);

        protected List<ListenableFuture<? extends T>> getFinalResultList() {
            if (this.buildingResult == EMPTY_ARRAY) {
                return Collections.emptyList();
            }
            List<ListenableFuture<? extends T>> result = Arrays.asList(this.buildingResult);
            this.buildingResult = null;
            return result;
        }

        protected class FutureDoneTask
        implements Runnable {
            private final ListenableFuture<? extends T> f;
            private final int index;

            protected FutureDoneTask(ListenableFuture<? extends T> f, int index) {
                this.f = f;
                this.index = index;
            }

            @Override
            public void run() {
                try {
                    FutureCollection.this.handleFutureDone(this.f, this.index);
                }
                finally {
                    if (FutureCollection.this.remainingResult.decrementAndGet() == 0) {
                        FutureCollection.this.completeWithResult(FutureCollection.this.getFinalResultList());
                    }
                }
            }
        }
    }

    protected static final class CancelDelegateSettableListenableFuture<T>
    extends SettableListenableFuture<T> {
        private volatile ListenableFuture<?> delegateFuture;

        protected CancelDelegateSettableListenableFuture(ListenableFuture<?> lf, Executor executingExecutor) {
            super(false, executingExecutor);
            this.delegateFuture = lf;
        }

        public void updateDelegateFuture(ListenableFuture<?> lf) {
            this.delegateFuture = lf;
        }

        @Override
        protected void handleCompleteState() {
            super.handleCompleteState();
            this.delegateFuture = null;
        }

        @Override
        public StackTraceElement[] getRunningStackTrace() {
            StackTraceElement[] result;
            ListenableFuture<?> delegateFuture = this.delegateFuture;
            if (delegateFuture != null && (result = delegateFuture.getRunningStackTrace()) != null) {
                return result;
            }
            return super.getRunningStackTrace();
        }

        @Override
        public boolean cancel(boolean interruptThread) {
            ListenableFuture<?> cancelFuture = this.delegateFuture;
            if (interruptThread) {
                if (super.cancel(true)) {
                    cancelFuture.cancel(true);
                    return true;
                }
                return false;
            }
            if (cancelFuture != null && cancelFuture.cancel(false)) {
                super.cancel(false);
                return true;
            }
            return false;
        }
    }

    protected static abstract class FailurePropogatingFutureCallback<T>
    implements FutureCallback<T> {
        protected static final RuntimeException IGNORED_FAILURE = new StackSuppressedRuntimeException();
        private final SettableListenableFuture<?> settableFuture;

        protected FailurePropogatingFutureCallback(SettableListenableFuture<?> settableFuture) {
            this.settableFuture = settableFuture;
        }

        @Override
        public void handleFailure(Throwable t) {
            if (t != IGNORED_FAILURE) {
                this.settableFuture.handleFailure(t);
            }
        }
    }
}

