/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import org.threadly.concurrent.ContainerHelper;
import org.threadly.util.ExceptionUtils;
import org.threadly.util.Pair;

public class RunnableListenerHelper {
    protected final Object listenersLock = new Object();
    protected final boolean callOnce;
    protected volatile boolean done;
    protected List<Runnable> inThreadListeners;
    protected List<Pair<Runnable, Executor>> executorListeners;

    public RunnableListenerHelper(boolean callListenersOnce) {
        this.callOnce = callListenersOnce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Runnable> getSubscribedListeners() {
        Object object = this.listenersLock;
        synchronized (object) {
            if (this.inThreadListeners == null && this.executorListeners == null) {
                return Collections.emptyList();
            }
            if (this.inThreadListeners == null) {
                return Collections.unmodifiableList(Pair.collectLeft(this.executorListeners));
            }
            if (this.executorListeners == null) {
                return Collections.unmodifiableList(this.inThreadListeners);
            }
            List<Runnable> listeners = Pair.collectLeft(this.executorListeners);
            listeners.addAll(this.inThreadListeners);
            return Collections.unmodifiableList(listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callListeners() {
        Object object = this.listenersLock;
        synchronized (object) {
            int i;
            if (this.callOnce) {
                if (this.done) {
                    throw new IllegalStateException("Already called listeners");
                }
                this.done = true;
            }
            if (this.executorListeners != null) {
                List<Pair<Runnable, Executor>> executorListeners = this.executorListeners;
                for (i = 0; i < executorListeners.size(); ++i) {
                    try {
                        Pair<Runnable, Executor> listener = executorListeners.get(i);
                        listener.getRight().execute(listener.getLeft());
                        continue;
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleException(t);
                    }
                }
            }
            if (this.inThreadListeners != null) {
                List<Runnable> inThreadListeners = this.inThreadListeners;
                for (i = 0; i < inThreadListeners.size(); ++i) {
                    try {
                        inThreadListeners.get(i).run();
                        continue;
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleException(t);
                    }
                }
            }
            if (this.callOnce) {
                this.executorListeners = null;
                this.inThreadListeners = null;
            }
        }
    }

    public void addListener(Runnable listener) {
        this.addListener(listener, null, null);
    }

    public void addListener(Runnable listener, Executor executor) {
        this.addListener(listener, executor, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Runnable listener, Executor queueExecutor, Executor inThreadExecutionExecutor) {
        if (listener == null) {
            return;
        }
        boolean runListener = this.done;
        if (!runListener) {
            boolean addingFromCallingThread = Thread.holdsLock(this.listenersLock);
            Object object = this.listenersLock;
            synchronized (object) {
                runListener = this.done;
                if (!runListener) {
                    if (queueExecutor == null) {
                        if (addingFromCallingThread && this.inThreadListeners != null) {
                            this.inThreadListeners = RunnableListenerHelper.copyAndAdd(this.inThreadListeners, listener);
                        } else if (this.inThreadListeners == null) {
                            this.inThreadListeners = Collections.singletonList(listener);
                        } else if (this.inThreadListeners.size() == 1) {
                            Runnable firstListener = this.inThreadListeners.get(0);
                            this.inThreadListeners = new ArrayList<Runnable>(4);
                            this.inThreadListeners.add(firstListener);
                            this.inThreadListeners.add(listener);
                        } else {
                            this.inThreadListeners.add(listener);
                        }
                    } else if (addingFromCallingThread && this.executorListeners != null) {
                        this.executorListeners = RunnableListenerHelper.copyAndAdd(this.executorListeners, new Pair<Runnable, Executor>(listener, queueExecutor));
                    } else if (this.executorListeners == null) {
                        this.executorListeners = Collections.singletonList(new Pair<Runnable, Executor>(listener, queueExecutor));
                    } else if (this.executorListeners.size() == 1) {
                        Pair<Runnable, Executor> firstP = this.executorListeners.get(0);
                        this.executorListeners = new ArrayList<Pair<Runnable, Executor>>(4);
                        this.executorListeners.add(firstP);
                        this.executorListeners.add(new Pair<Runnable, Executor>(listener, queueExecutor));
                    } else {
                        this.executorListeners.add(new Pair<Runnable, Executor>(listener, queueExecutor));
                    }
                }
            }
        }
        if (runListener) {
            try {
                if (inThreadExecutionExecutor != null) {
                    inThreadExecutionExecutor.execute(listener);
                } else {
                    listener.run();
                }
            }
            catch (Throwable t) {
                throw ExceptionUtils.makeRuntime(t);
            }
        }
    }

    private static <T> List<T> copyAndAdd(List<T> sourceList, T item) {
        ArrayList<T> result = new ArrayList<T>(sourceList.size() + 1);
        result.addAll(sourceList);
        result.add(item);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(Runnable listener) {
        boolean removingFromCallingThread = Thread.holdsLock(this.listenersLock);
        Object object = this.listenersLock;
        synchronized (object) {
            int i;
            if (this.executorListeners != null) {
                if (this.executorListeners.size() == 1) {
                    if (ContainerHelper.isContained(this.executorListeners.get(0).getLeft(), listener)) {
                        this.executorListeners = null;
                        return true;
                    }
                    return false;
                }
                i = 0;
                for (Pair pair : this.executorListeners) {
                    if (ContainerHelper.isContained((Runnable)pair.getLeft(), listener)) {
                        if (removingFromCallingThread) {
                            this.executorListeners = new ArrayList<Pair<Runnable, Executor>>(this.executorListeners);
                        }
                        this.executorListeners.remove(i);
                        return true;
                    }
                    ++i;
                }
            }
            if (this.inThreadListeners != null) {
                if (this.inThreadListeners.size() == 1) {
                    if (ContainerHelper.isContained(this.inThreadListeners.get(0), listener)) {
                        this.inThreadListeners = null;
                        return true;
                    }
                    return false;
                }
                i = 0;
                for (Runnable runnable : this.inThreadListeners) {
                    if (ContainerHelper.isContained(runnable, listener)) {
                        if (removingFromCallingThread) {
                            this.inThreadListeners = new ArrayList<Runnable>(this.inThreadListeners);
                        }
                        this.inThreadListeners.remove(i);
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearListeners() {
        Object object = this.listenersLock;
        synchronized (object) {
            this.executorListeners = null;
            this.inThreadListeners = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registeredListenerCount() {
        Object object = this.listenersLock;
        synchronized (object) {
            return (this.executorListeners == null ? 0 : this.executorListeners.size()) + (this.inThreadListeners == null ? 0 : this.inThreadListeners.size());
        }
    }
}

