/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.event;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import org.threadly.util.ArgumentVerifier;
import org.threadly.util.ExceptionUtils;
import org.threadly.util.Pair;

public class ListenerHelper<T> {
    protected final T proxyInstance;
    protected final Object listenersLock;
    protected List<T> inThreadListeners;
    protected List<Pair<T, Executor>> executorListeners;

    public ListenerHelper(Class<? super T> listenerInterface) {
        ArgumentVerifier.assertNotNull(listenerInterface, "listenerInterface");
        if (!listenerInterface.isInterface()) {
            throw new IllegalArgumentException("listenerInterface must be an interface");
        }
        this.proxyInstance = this.makeProxyInstance(listenerInterface);
        this.listenersLock = new Object();
    }

    protected T makeProxyInstance(Class<? super T> listenerInterface) {
        return (T)Proxy.newProxyInstance(listenerInterface.getClassLoader(), new Class[]{listenerInterface}, (InvocationHandler)new ListenerCaller());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> getSubscribedListeners() {
        Object object = this.listenersLock;
        synchronized (object) {
            if (this.inThreadListeners == null && this.executorListeners == null) {
                return Collections.emptyList();
            }
            if (this.inThreadListeners == null) {
                return Collections.unmodifiableList(Pair.collectLeft(this.executorListeners));
            }
            if (this.executorListeners == null) {
                return Collections.unmodifiableList(this.inThreadListeners);
            }
            List<T> listeners = Pair.collectLeft(this.executorListeners);
            listeners.addAll(this.inThreadListeners);
            return Collections.unmodifiableList(listeners);
        }
    }

    public T call() {
        return this.proxyInstance;
    }

    public void addListener(T listener) {
        this.addListener(listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(T listener, Executor executor) {
        if (listener == null) {
            return;
        }
        boolean addingFromCallingThread = Thread.holdsLock(this.listenersLock);
        Object object = this.listenersLock;
        synchronized (object) {
            if (executor == null) {
                if (addingFromCallingThread && this.inThreadListeners != null) {
                    this.inThreadListeners = ListenerHelper.copyAndAdd(this.inThreadListeners, listener);
                } else if (this.inThreadListeners == null) {
                    this.inThreadListeners = Collections.singletonList(listener);
                } else if (this.inThreadListeners.size() == 1) {
                    T firstListener = this.inThreadListeners.get(0);
                    this.inThreadListeners = new ArrayList<T>(4);
                    this.inThreadListeners.add(firstListener);
                    this.inThreadListeners.add(listener);
                } else {
                    this.inThreadListeners.add(listener);
                }
            } else if (addingFromCallingThread && this.executorListeners != null) {
                this.executorListeners = ListenerHelper.copyAndAdd(this.executorListeners, new Pair<T, Executor>(listener, executor));
            } else if (this.executorListeners == null) {
                this.executorListeners = Collections.singletonList(new Pair<T, Executor>(listener, executor));
            } else if (this.executorListeners.size() == 1) {
                Pair<T, Executor> firstP = this.executorListeners.get(0);
                this.executorListeners = new ArrayList<Pair<T, Executor>>(4);
                this.executorListeners.add(firstP);
                this.executorListeners.add(new Pair<T, Executor>(listener, executor));
            } else {
                this.executorListeners.add(new Pair<T, Executor>(listener, executor));
            }
        }
    }

    private static <T> List<T> copyAndAdd(List<T> sourceList, T item) {
        ArrayList<T> result = new ArrayList<T>(sourceList.size() + 1);
        result.addAll(sourceList);
        result.add(item);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(T listener) {
        boolean removingFromCallingThread = Thread.holdsLock(this.listenersLock);
        Object object = this.listenersLock;
        synchronized (object) {
            int i;
            if (this.executorListeners != null) {
                if (this.executorListeners.size() == 1) {
                    if (this.executorListeners.get(0).getLeft().equals(listener)) {
                        this.executorListeners = null;
                        return true;
                    }
                    return false;
                }
                i = 0;
                for (Pair<Object, Executor> pair : this.executorListeners) {
                    if (pair.getLeft().equals(listener)) {
                        if (removingFromCallingThread) {
                            this.executorListeners = new ArrayList<Pair<T, Executor>>(this.executorListeners);
                        }
                        this.executorListeners.remove(i);
                        return true;
                    }
                    ++i;
                }
            }
            if (this.inThreadListeners != null) {
                if (this.inThreadListeners.size() == 1) {
                    if (this.inThreadListeners.get(0).equals(listener)) {
                        this.inThreadListeners = null;
                        return true;
                    }
                    return false;
                }
                i = 0;
                for (Pair<Object, Executor> pair : this.inThreadListeners) {
                    if (((Object)pair).equals(listener)) {
                        if (removingFromCallingThread) {
                            this.inThreadListeners = new ArrayList<T>(this.inThreadListeners);
                        }
                        this.inThreadListeners.remove(i);
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearListeners() {
        Object object = this.listenersLock;
        synchronized (object) {
            this.executorListeners = null;
            this.inThreadListeners = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registeredListenerCount() {
        Object object = this.listenersLock;
        synchronized (object) {
            return (this.executorListeners == null ? 0 : this.executorListeners.size()) + (this.inThreadListeners == null ? 0 : this.inThreadListeners.size());
        }
    }

    protected class ListenerCaller
    implements InvocationHandler {
        protected ListenerCaller() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            this.verifyValidMethod(method);
            this.callListeners(method, args);
            return null;
        }

        protected void verifyValidMethod(Method method) {
            if (!method.isDefault() && !method.getReturnType().equals(Void.TYPE)) {
                throw new RuntimeException("Can only call listeners with a void return type");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void callListeners(final Method method, final Object[] args) {
            Object object = ListenerHelper.this.listenersLock;
            synchronized (object) {
                int i;
                List<Pair<Object, Executor>> listeners;
                if (ListenerHelper.this.executorListeners != null) {
                    listeners = ListenerHelper.this.executorListeners;
                    for (i = 0; i < listeners.size(); ++i) {
                        final Pair<Object, Executor> listener = listeners.get(i);
                        listener.getRight().execute(new Runnable(){

                            @Override
                            public void run() {
                                ListenerCaller.this.callListener(listener.getLeft(), method, args);
                            }
                        });
                    }
                }
                if (ListenerHelper.this.inThreadListeners != null) {
                    listeners = ListenerHelper.this.inThreadListeners;
                    for (i = 0; i < listeners.size(); ++i) {
                        this.callListener(listeners.get(i), method, args);
                    }
                }
            }
        }

        protected void callListener(T listener, Method method, Object[] args) {
            try {
                method.invoke(listener, args);
            }
            catch (IllegalAccessException e) {
                ExceptionUtils.handleException(e);
            }
            catch (InvocationTargetException e) {
                ExceptionUtils.handleException(e.getCause());
            }
        }
    }
}

