/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.event;

import java.util.List;
import java.util.concurrent.Executor;
import org.threadly.concurrent.event.RunnableListenerHelper;
import org.threadly.util.ArgumentVerifier;
import org.threadly.util.ExceptionUtils;
import org.threadly.util.Pair;

public class AsyncCallRunnableListenerHelper
extends RunnableListenerHelper {
    protected final Executor executor;
    protected final CallListenersTask callListenersTask = new CallListenersTask();

    public AsyncCallRunnableListenerHelper(boolean callListenersOnce, Executor executor) {
        super(callListenersOnce);
        ArgumentVerifier.assertNotNull(executor, "executor");
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callListeners() {
        Object object = this.listenersLock;
        synchronized (object) {
            if (this.callOnce) {
                if (this.done) {
                    throw new IllegalStateException("Already called listeners");
                }
                this.done = true;
            }
        }
        this.executor.execute(this.callListenersTask);
    }

    protected class CallListenersTask
    implements Runnable {
        protected CallListenersTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = AsyncCallRunnableListenerHelper.this.listenersLock;
            synchronized (object) {
                int i;
                if (AsyncCallRunnableListenerHelper.this.executorListeners != null) {
                    List executorListeners = AsyncCallRunnableListenerHelper.this.executorListeners;
                    for (i = 0; i < executorListeners.size(); ++i) {
                        try {
                            Pair listener = (Pair)executorListeners.get(i);
                            ((Executor)listener.getRight()).execute((Runnable)listener.getLeft());
                            continue;
                        }
                        catch (Throwable t) {
                            ExceptionUtils.handleException(t);
                        }
                    }
                }
                if (AsyncCallRunnableListenerHelper.this.inThreadListeners != null) {
                    List inThreadListeners = AsyncCallRunnableListenerHelper.this.inThreadListeners;
                    for (i = 0; i < inThreadListeners.size(); ++i) {
                        try {
                            ((Runnable)inThreadListeners.get(i)).run();
                            continue;
                        }
                        catch (Throwable t) {
                            ExceptionUtils.handleException(t);
                        }
                    }
                }
                if (AsyncCallRunnableListenerHelper.this.callOnce) {
                    AsyncCallRunnableListenerHelper.this.executorListeners = null;
                    AsyncCallRunnableListenerHelper.this.inThreadListeners = null;
                }
            }
        }
    }
}

