/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import org.threadly.concurrent.AbstractSubmitterExecutor;
import org.threadly.concurrent.ConfigurableThreadFactory;
import org.threadly.util.AbstractService;
import org.threadly.util.ArgumentVerifier;
import org.threadly.util.Clock;
import org.threadly.util.ExceptionUtils;

public class UnfairExecutor
extends AbstractSubmitterExecutor {
    protected final Worker[] schedulers;
    private final AtomicBoolean shutdownStarted;
    private final TaskStripeGenerator stripeGenerator;

    public UnfairExecutor(int threadCount) {
        this(threadCount, true, (TaskStripeGenerator)TaskHashXorTimeStripeGenerator.instance());
    }

    public UnfairExecutor(int threadCount, TaskStripeGenerator stripeGenerator) {
        this(threadCount, true, stripeGenerator);
    }

    public UnfairExecutor(int threadCount, boolean useDaemonThreads) {
        this(threadCount, useDaemonThreads, (TaskStripeGenerator)TaskHashXorTimeStripeGenerator.instance());
    }

    public UnfairExecutor(int threadCount, boolean useDaemonThreads, TaskStripeGenerator stripeGenerator) {
        this(threadCount, new ConfigurableThreadFactory(UnfairExecutor.class.getSimpleName() + "-", true, useDaemonThreads, 5, null, null, null), stripeGenerator);
    }

    public UnfairExecutor(int threadCount, ThreadFactory threadFactory) {
        this(threadCount, threadFactory, (TaskStripeGenerator)TaskHashXorTimeStripeGenerator.instance());
    }

    public UnfairExecutor(int threadCount, ThreadFactory threadFactory, TaskStripeGenerator stripeGenerator) {
        ArgumentVerifier.assertGreaterThanZero(threadCount, "threadCount");
        ArgumentVerifier.assertNotNull(stripeGenerator, "stripeGenerator");
        this.schedulers = new Worker[threadCount];
        this.shutdownStarted = new AtomicBoolean(false);
        this.stripeGenerator = stripeGenerator;
        for (int i = 0; i < threadCount; ++i) {
            this.schedulers[i] = new Worker(threadFactory);
            if (i <= 0) continue;
            this.schedulers[i].setNeighborWorker(this.schedulers[i - 1]);
        }
        this.schedulers[0].setNeighborWorker(this.schedulers[this.schedulers.length - 1]);
        final Worker firstWorker = this.schedulers[0];
        firstWorker.addTask(new Runnable(){

            @Override
            public void run() {
                for (Worker w : UnfairExecutor.this.schedulers) {
                    if (w == firstWorker) continue;
                    w.start();
                }
            }
        });
        firstWorker.start();
    }

    @Override
    protected void doExecute(Runnable task) {
        if (this.shutdownStarted.get()) {
            throw new RejectedExecutionException("Pool is shutdown");
        }
        this.schedulers[Math.floorMod(this.stripeGenerator.getStripe(task), this.schedulers.length)].addTask(task);
    }

    public boolean isShutdown() {
        return this.shutdownStarted.get();
    }

    public void shutdown() {
        if (this.shutdownStarted.compareAndSet(false, true)) {
            for (Worker w : this.schedulers) {
                w.addTask(new ShutdownTask(w));
            }
        }
    }

    public List<Runnable> shutdownNow() {
        this.shutdownStarted.set(true);
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        for (Worker w : this.schedulers) {
            w.stopIfRunning();
            Iterator it = w.taskQueue.iterator();
            while (it.hasNext()) {
                Runnable task = (Runnable)it.next();
                it.remove();
                if (task instanceof ShutdownTask) continue;
                result.add(task);
            }
        }
        return result;
    }

    public void awaitTermination() throws InterruptedException {
        for (Worker w : this.schedulers) {
            w.thread.join();
        }
    }

    public boolean awaitTermination(long timeoutMillis) throws InterruptedException {
        long startTime = Clock.accurateForwardProgressingMillis();
        for (Worker w : this.schedulers) {
            long remainingWait = timeoutMillis - (Clock.lastKnownForwardProgressingMillis() - startTime);
            if (remainingWait > 0L) {
                w.thread.join(remainingWait);
            }
            if (!w.thread.isAlive()) continue;
            return false;
        }
        return true;
    }

    protected void finalize() throws Throwable {
        this.shutdown();
    }

    private static class ShutdownTask
    implements Runnable {
        private final Worker w;

        public ShutdownTask(Worker w) {
            this.w = w;
        }

        @Override
        public void run() {
            this.w.stopIfRunning();
            this.w.taskQueue.clear();
        }
    }

    protected static class Worker
    extends AbstractService
    implements Runnable {
        protected final Thread thread;
        protected final Queue<Runnable> taskQueue;
        private volatile boolean parked;
        private Worker checkNeighborWorker;
        private Worker wakupNeighborWorker;

        public Worker(ThreadFactory threadFactory) {
            this.thread = threadFactory.newThread(this);
            if (this.thread.isAlive()) {
                throw new IllegalThreadStateException();
            }
            this.taskQueue = new ConcurrentLinkedQueue<Runnable>();
            this.parked = false;
        }

        protected void setNeighborWorker(Worker w) {
            this.checkNeighborWorker = w;
            w.wakupNeighborWorker = this;
        }

        @Override
        protected void startupService() {
            if (this.checkNeighborWorker == null || this.wakupNeighborWorker == null) {
                throw new IllegalStateException();
            }
            this.thread.start();
        }

        @Override
        protected void shutdownService() {
            LockSupport.unpark(this.thread);
        }

        public void addTask(Runnable task) {
            this.taskQueue.add(task);
            if (this.parked) {
                this.parked = false;
                LockSupport.unpark(this.thread);
            } else if (this.wakupNeighborWorker.parked) {
                this.wakupNeighborWorker.parked = false;
                LockSupport.unpark(this.wakupNeighborWorker.thread);
            }
        }

        @Override
        public void run() {
            while (this.isRunning()) {
                Runnable task = this.taskQueue.poll();
                Thread.interrupted();
                if (task != null) {
                    if (this.parked) {
                        this.parked = false;
                    }
                    try {
                        task.run();
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleException(t);
                    }
                    continue;
                }
                if (!this.parked) {
                    task = this.checkNeighborWorker.taskQueue.poll();
                    if (task != null) {
                        try {
                            task.run();
                        }
                        catch (Throwable t) {
                            ExceptionUtils.handleException(t);
                        }
                        continue;
                    }
                    this.parked = true;
                    continue;
                }
                LockSupport.park();
            }
        }
    }

    public static class AtomicStripeGenerator
    implements TaskStripeGenerator {
        private final AtomicLong stripe = new AtomicLong();

        public static AtomicStripeGenerator instance() {
            return new AtomicStripeGenerator();
        }

        private AtomicStripeGenerator() {
        }

        @Override
        public long getStripe(Runnable task) {
            return this.stripe.getAndIncrement();
        }
    }

    public static class TaskHashXorTimeStripeGenerator
    implements TaskStripeGenerator {
        private static final TaskHashXorTimeStripeGenerator INSTANCE = new TaskHashXorTimeStripeGenerator();

        public static TaskHashXorTimeStripeGenerator instance() {
            return INSTANCE;
        }

        private TaskHashXorTimeStripeGenerator() {
        }

        @Override
        public long getStripe(Runnable task) {
            return (long)System.identityHashCode(task) ^ Clock.lastKnownTimeNanos();
        }
    }

    public static interface TaskStripeGenerator {
        public long getStripe(Runnable var1);
    }
}

