/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.threadly.concurrent.SameThreadSubmitterExecutor;
import org.threadly.concurrent.SubmitterScheduler;
import org.threadly.util.ArgumentVerifier;

public abstract class ReschedulingOperation {
    protected final Executor executor;
    private final SubmitterScheduler scheduler;
    private final int maxOperationLoops;
    private final AtomicInteger taskState;
    private final CheckRunner runner;
    private volatile long scheduleDelay;

    protected ReschedulingOperation(Executor executor) {
        this(1000, executor);
    }

    protected ReschedulingOperation(int maxOperationLoops, Executor executor) {
        this(executor, maxOperationLoops, null, 0L);
        ArgumentVerifier.assertNotNull(executor, "executor");
    }

    protected ReschedulingOperation(SubmitterScheduler scheduler, long scheduleDelay) {
        this(scheduler, 0, scheduler, scheduleDelay);
        ArgumentVerifier.assertNotNull(scheduler, "scheduler");
    }

    private ReschedulingOperation(Executor executor, int maxOperationLoops, SubmitterScheduler scheduler, long scheduleDelay) {
        ArgumentVerifier.assertNotNegative(scheduleDelay, "scheduleDelay");
        this.executor = executor;
        this.scheduler = scheduler;
        this.maxOperationLoops = executor == SameThreadSubmitterExecutor.instance() ? Integer.MAX_VALUE : maxOperationLoops;
        this.taskState = new AtomicInteger(-1);
        this.runner = new CheckRunner();
        this.scheduleDelay = scheduleDelay;
    }

    public boolean isActive() {
        return this.taskState.get() != -1;
    }

    public void setScheduleDelay(long scheduleDelay) {
        if (this.scheduler == null && scheduleDelay != 0L) {
            throw new UnsupportedOperationException("Only an executor is provided, scheduling not possible");
        }
        ArgumentVerifier.assertNotNegative(scheduleDelay, "scheduleDelay");
        this.scheduleDelay = scheduleDelay;
    }

    private boolean firstSignal() {
        block2: {
            while (true) {
                int casState;
                if ((casState = this.taskState.get()) == -1) {
                    if (!this.taskState.weakCompareAndSetVolatile(-1, 0)) continue;
                    return true;
                }
                if (casState != 1) break block2;
                if (this.taskState.weakCompareAndSetVolatile(1, 2)) break;
            }
            return false;
        }
        return false;
    }

    public void signalToRunImmediately(boolean runOnCallingThreadIfPossible) {
        if (this.firstSignal()) {
            if (runOnCallingThreadIfPossible) {
                this.runner.run();
            } else {
                this.executor.execute(this.runner);
            }
        }
    }

    public void signalToRun() {
        if (this.firstSignal()) {
            if (this.scheduler != null) {
                this.scheduler.schedule(this.runner, this.scheduleDelay);
            } else {
                this.executor.execute(this.runner);
            }
        }
    }

    protected abstract void run();

    protected class CheckRunner
    implements Runnable {
        protected CheckRunner() {
        }

        @Override
        public void run() {
            int loopCount = 0;
            block3: while (true) {
                ReschedulingOperation.this.taskState.set(1);
                try {
                    ReschedulingOperation.this.run();
                    continue;
                }
                finally {
                    while (true) {
                        if (ReschedulingOperation.this.taskState.get() == 1) {
                            if (!ReschedulingOperation.this.taskState.weakCompareAndSetVolatile(1, -1)) continue;
                            break block3;
                        }
                        if (ReschedulingOperation.this.taskState.get() == 2) break;
                    }
                    if (ReschedulingOperation.this.scheduleDelay == 0L) {
                        if (++loopCount < ReschedulingOperation.this.maxOperationLoops) continue;
                        ReschedulingOperation.this.executor.execute(this);
                        break;
                    }
                    ReschedulingOperation.this.scheduler.schedule(this, ReschedulingOperation.this.scheduleDelay);
                    break;
                    continue;
                }
                break;
            }
        }

        public String toString() {
            return "ReschedulingOperationRunner for: " + ReschedulingOperation.this.toString();
        }
    }
}

