/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.notickvd.common;

import com.ishland.c2me.base.common.structs.DynamicPriorityQueue;
import com.ishland.c2me.base.mixin.access.IChunkTicketManager;
import com.ishland.c2me.base.mixin.access.IThreadedAnvilChunkStorage;
import com.ishland.c2me.notickvd.common.Config;
import com.ishland.c2me.notickvd.common.NoTickSystem;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.minecraft.class_1923;
import net.minecraft.class_3193;
import net.minecraft.class_3196;
import net.minecraft.class_3204;
import net.minecraft.class_3230;
import net.minecraft.class_3532;
import net.minecraft.class_3898;
import org.slf4j.Logger;

public class PlayerNoTickDistanceMap
extends class_3196 {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final class_3230<class_1923> TICKET_TYPE = class_3230.method_14291((String)"c2me_no_tick_vd", Comparator.comparingLong(class_1923::method_8324));
    private final LongSet sourceChunks = new LongOpenHashSet();
    private final Long2IntOpenHashMap distanceFromNearestPlayer = new Long2IntOpenHashMap();
    private final DynamicPriorityQueue<class_1923> pendingTicketAdds = new DynamicPriorityQueue(251);
    private final LongOpenHashSet pendingTicketRemoves = new LongOpenHashSet();
    private final LongOpenHashSet managedChunkTickets = new LongOpenHashSet();
    private final ReferenceArrayList<CompletableFuture<Void>> chunkLoadFutures = new ReferenceArrayList();
    private final class_3204 chunkTicketManager;
    private final NoTickSystem noTickSystem;
    private volatile int viewDistance;
    private volatile int pendingTicketUpdatesCount = 0;
    private boolean hasPendingTicketUpdatesAsync = false;

    public PlayerNoTickDistanceMap(class_3204 chunkTicketManager, NoTickSystem noTickSystem) {
        super(251, 16, 256);
        this.chunkTicketManager = chunkTicketManager;
        this.noTickSystem = noTickSystem;
        this.distanceFromNearestPlayer.defaultReturnValue(251);
        this.setViewDistance(12);
    }

    protected int method_14028(long chunkPos) {
        ObjectSet players = (ObjectSet)((IChunkTicketManager)this.chunkTicketManager).getPlayersByChunkPos().get(chunkPos);
        return players != null && !players.isEmpty() ? 249 - this.viewDistance : Integer.MAX_VALUE;
    }

    protected int method_15480(long chunkPos) {
        return this.distanceFromNearestPlayer.get(chunkPos);
    }

    protected void method_15485(long chunkPos, int level) {
        if (level > 249) {
            if (this.distanceFromNearestPlayer.containsKey(chunkPos)) {
                this.pendingTicketRemoves.add(chunkPos);
                this.pendingTicketAdds.remove((Object)new class_1923(chunkPos));
                this.distanceFromNearestPlayer.remove(chunkPos);
            }
        } else {
            if (!this.distanceFromNearestPlayer.containsKey(chunkPos)) {
                this.pendingTicketRemoves.remove(chunkPos);
                this.pendingTicketAdds.enqueue((Object)new class_1923(chunkPos), level);
            }
            this.pendingTicketAdds.changePriority((Object)new class_1923(chunkPos), level);
            this.distanceFromNearestPlayer.put(chunkPos, level);
        }
    }

    public void addSource(class_1923 chunkPos) {
        this.method_14027(chunkPos.method_8324(), 249 - this.viewDistance, true);
        this.sourceChunks.add(chunkPos.method_8324());
    }

    public void removeSource(class_1923 chunkPos) {
        this.method_14027(chunkPos.method_8324(), Integer.MAX_VALUE, false);
        this.sourceChunks.remove(chunkPos.method_8324());
    }

    public boolean update() {
        boolean hasUpdates = this.method_15492(Integer.MAX_VALUE) != Integer.MAX_VALUE;
        this.pendingTicketUpdatesCount = this.pendingTicketAdds.size() + this.pendingTicketRemoves.size();
        return hasUpdates;
    }

    boolean runPendingTicketUpdates(class_3898 tacs) {
        boolean hasUpdatesNow = this.runPendingTicketUpdatesInternal(tacs);
        boolean hasUpdatesEarlier = this.hasPendingTicketUpdatesAsync;
        this.hasPendingTicketUpdatesAsync = false;
        return hasUpdatesNow || hasUpdatesEarlier;
    }

    private boolean runPendingTicketUpdatesInternal(class_3898 tacs) {
        class_1923 pos;
        boolean hasUpdates = false;
        LongIterator it = this.pendingTicketRemoves.longIterator();
        while (it.hasNext()) {
            long chunkPos = it.nextLong();
            if (!this.managedChunkTickets.remove(chunkPos)) continue;
            this.removeTicket0(new class_1923(chunkPos));
            hasUpdates = true;
        }
        this.pendingTicketRemoves.clear();
        this.chunkLoadFutures.removeIf(CompletableFuture::isDone);
        while (this.chunkLoadFutures.size() < Config.maxConcurrentChunkLoads && (pos = (class_1923)this.pendingTicketAdds.dequeue()) != null) {
            if (!this.managedChunkTickets.add(pos.method_8324())) continue;
            CompletableFuture<Void> ticketFuture = this.addTicket0(pos);
            this.chunkLoadFutures.add(this.getChunkLoadFuture(tacs, pos, ticketFuture));
            hasUpdates = true;
        }
        this.pendingTicketUpdatesCount = this.pendingTicketAdds.size() + this.pendingTicketRemoves.size();
        return hasUpdates;
    }

    private void removeTicket0(class_1923 pos) {
        this.noTickSystem.mainBeforeTicketTicks.add(() -> this.chunkTicketManager.method_20444(TICKET_TYPE, pos, 33, (Object)pos));
    }

    private CompletableFuture<Void> addTicket0(class_1923 pos) {
        return CompletableFuture.runAsync(() -> this.chunkTicketManager.method_17290(TICKET_TYPE, pos, 33, (Object)pos), this.noTickSystem.mainBeforeTicketTicks::add);
    }

    private CompletableFuture<Void> getChunkLoadFuture(class_3898 tacs, class_1923 pos, CompletableFuture<Void> ticketFuture) {
        CompletionStage future = ticketFuture.thenComposeAsync(unused -> {
            class_3193 holder = (class_3193)((IThreadedAnvilChunkStorage)tacs).getCurrentChunkHolders().get(pos.method_8324());
            if (holder == null) {
                return CompletableFuture.completedFuture(null);
            }
            return ((CompletableFuture)holder.method_20725().exceptionally(unused1 -> null)).thenAccept(unused1 -> {});
        }, this.noTickSystem.mainAfterTicketTicks::add);
        ((CompletableFuture)future).thenRunAsync(() -> this.lambda$getChunkLoadFuture$5((CompletableFuture)future, tacs), this.noTickSystem.executor);
        return future;
    }

    public void setViewDistance(int viewDistance) {
        this.viewDistance = class_3532.method_15340((int)viewDistance, (int)3, (int)249);
        this.sourceChunks.forEach(value -> {
            this.removeSource(new class_1923(value));
            this.addSource(new class_1923(value));
        });
    }

    public int getPendingTicketUpdatesCount() {
        return this.pendingTicketUpdatesCount;
    }

    public LongSet getChunks() {
        return this.managedChunkTickets;
    }

    private /* synthetic */ void lambda$getChunkLoadFuture$5(CompletableFuture future, class_3898 tacs) {
        this.chunkLoadFutures.remove((Object)future);
        boolean hasUpdates = this.runPendingTicketUpdatesInternal(tacs);
        if (hasUpdates) {
            this.hasPendingTicketUpdatesAsync = true;
        }
    }
}

