/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepspeak.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class Util {
    public static float lerp(float d, float v1, float v2) {
        return v1 + d * (v2 - v1);
    }

    public static float max(float[] values) {
        float max = 0.0f;
        for (float f : values) {
            max = Math.max(f, max);
        }
        return max;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static float[] loadFileToFloats(String resourcePath) {
        try (AudioInputStream stream = Util.loadResource(resourcePath);){
            if (stream == null) throw new IllegalArgumentException("Failed to load file %s".formatted(resourcePath));
            AudioFormat format = stream.getFormat();
            byte[] bytes = stream.readAllBytes();
            ByteBuffer bb = ByteBuffer.allocate(bytes.length);
            bb.order(format.isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
            int sampleBytes = format.getSampleSizeInBits() / 8;
            int channels = format.getChannels();
            if (channels != 1) throw new IllegalArgumentException("audio file " + resourcePath + " does not match required format");
            if (sampleBytes != 2) throw new IllegalArgumentException("audio file " + resourcePath + " does not match required format");
            if (format.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) throw new IllegalArgumentException("audio file " + resourcePath + " does not match required format");
            if (format.getSampleRate() != 44100.0f) {
                throw new IllegalArgumentException("audio file " + resourcePath + " does not match required format");
            }
            bb.put(bytes);
            int numSamples = bytes.length / sampleBytes;
            float[] floats = new float[numSamples];
            int i = 0;
            while (true) {
                if (i >= numSamples) {
                    float[] fArray = floats;
                    return fArray;
                }
                short s = bb.getShort(i * sampleBytes);
                floats[i] = (float)((double)s / 32767.0);
                ++i;
            }
        }
        catch (IOException | UnsupportedAudioFileException e) {
            throw new IllegalArgumentException("Failed to load file %s: %s".formatted(resourcePath, e));
        }
    }

    public static AudioInputStream loadResource(String resourcePath) throws UnsupportedAudioFileException, IOException {
        InputStream stream = Util.class.getClassLoader().getResourceAsStream(resourcePath);
        if (stream != null) {
            return AudioSystem.getAudioInputStream(new BufferedInputStream(stream));
        }
        return null;
    }
}

