/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepspeak.util;

import java.util.Arrays;

public class SampleBuffer {
    public final float[] data;
    public int startSample;
    public int endSample;

    public SampleBuffer(float[] backing, int startSample, int endSampleExc) {
        this.data = backing;
        this.startSample = startSample;
        this.endSample = endSampleExc;
    }

    public SampleBuffer(int size) {
        this(new float[size], 0, size);
    }

    public void put(int n, float value) {
        this.data[n] = value;
    }

    public float[] array() {
        return this.data;
    }

    public int regionSize() {
        return this.endSample - this.startSample;
    }

    public void copyInto(SampleBuffer other, int size) {
        System.arraycopy(this.data, this.startSample, other.data, other.startSample, size);
    }

    public void addInto(SampleBuffer other, int size) {
        for (int i = 0; i < size; ++i) {
            int n = other.startSample + i;
            other.data[n] = other.data[n] + this.data[this.startSample + i];
        }
    }

    public void addInto(SampleBuffer other, int sourceStart, int destStart, int size) {
        for (int i = 0; i < size; ++i) {
            int n = destStart + i;
            other.data[n] = other.data[n] + this.data[sourceStart + i];
        }
    }

    public void clearRegion() {
        Arrays.fill(this.data, this.startSample, this.endSample, 0.0f);
    }

    public void fillFrom(float[] data, int sourceStart, int destStart, int size) {
        System.arraycopy(data, sourceStart, this.data, destStart, size);
    }

    public void applyRamp(float a0, float a1, int start, int endExc) {
        float a = a0;
        float step = (a1 - a0) / (float)(endExc - start);
        int i = start;
        while (i < endExc) {
            int n = i++;
            this.data[n] = this.data[n] * a;
            a += step;
        }
    }
}

