/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepspeak.util;

import com.neep.neepspeak.mouth.Waveforms;
import com.neep.neepspeak.util.SampleBuffer;
import com.neep.neepspeak.util.Util;
import java.util.function.Consumer;

public class FrequencySweep {
    private final float fs;
    private final float f0;
    private final float f1;
    private final int steps;
    private final int frameSize;

    public FrequencySweep(float fs, float f0, float f1, int steps, int frameSize) {
        this.fs = fs;
        this.f0 = f0;
        this.f1 = f1;
        this.steps = steps;
        this.frameSize = frameSize;
    }

    public FrequencyResponse apply(Consumer<SampleBuffer> system) {
        float[] h = new float[this.steps];
        float[] f = new float[this.steps];
        int cycles = 30;
        for (int step = 0; step < this.steps; ++step) {
            float stepF = this.f0 + (this.f1 - this.f0) * ((float)step / (float)this.steps);
            float samplesPerCycle = this.fs / stepF;
            int size = (int)((float)cycles * samplesPerCycle);
            int frames = 1 + (int)Math.ceil((double)size / (double)this.frameSize);
            float max = 0.0f;
            for (int frame = 0; frame < frames; ++frame) {
                SampleBuffer sb = new SampleBuffer(new float[this.frameSize], 0, this.frameSize);
                Waveforms.sine(sb, this.fs, stepF, 1.0f);
                system.accept(sb);
                if (frame <= 0) continue;
                max = Math.max(max, Util.max(sb.data));
            }
            h[step] = max;
            f[step] = stepF;
        }
        return new FrequencyResponse(f, h);
    }

    public record FrequencyResponse(float[] f, float[] h) {
    }
}

