/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepspeak.phoneme;

import com.neep.neepspeak.mouth.phoneme.DiphthongPhoneme;
import com.neep.neepspeak.mouth.phoneme.ObstruentPhoneme;
import com.neep.neepspeak.mouth.phoneme.PlayablePhoneme;
import com.neep.neepspeak.mouth.phoneme.SonorantPhoneme;
import com.neep.neepspeak.mouth.phoneme.SpacePhoneme;
import com.neep.neepspeak.phoneme.PhonemeFileSet;

public class PhonemeSet {
    public static final PhonemeSet NORMAL = new PhonemeSet(new PhonemeFileSet("phonemes/normal"));
    private final PhonemeFileSet fs;
    public final PlayablePhoneme SPACE = new SpacePhoneme(0.1f);
    public final PlayablePhoneme PAUSE = new SpacePhoneme(0.05f);
    public final PlayablePhoneme _A;
    public final PlayablePhoneme _a;
    public final PlayablePhoneme _E;
    public final PlayablePhoneme _I;
    public final PlayablePhoneme _U;
    public final PlayablePhoneme _i;
    public final PlayablePhoneme _V;
    public final PlayablePhoneme _o;
    public final PlayablePhoneme _O;
    public final PlayablePhoneme _u;
    public final PlayablePhoneme _3;
    public final PlayablePhoneme _at_1;
    public final PlayablePhoneme _at_2;
    public final PlayablePhoneme _r$;
    public final PlayablePhoneme _m;
    public final PlayablePhoneme _n;
    public final PlayablePhoneme _l;
    public final PlayablePhoneme _f;
    public final PlayablePhoneme _v;
    public final PlayablePhoneme _s;
    public final PlayablePhoneme _S;
    public final PlayablePhoneme _z;
    public final PlayablePhoneme _Z;
    public final PlayablePhoneme _w;
    public final PlayablePhoneme _T;
    public final PlayablePhoneme _x;
    public final PlayablePhoneme _D;
    public final PlayablePhoneme _h;
    public final PlayablePhoneme _N;
    public final PlayablePhoneme _b;
    public final PlayablePhoneme _p;
    public final PlayablePhoneme _g;
    public final PlayablePhoneme _dZ;
    public final PlayablePhoneme _d;
    public final PlayablePhoneme _t;
    public final PlayablePhoneme _k;
    public final PlayablePhoneme _tS;
    public final PlayablePhoneme _j;
    public final PlayablePhoneme _EI;
    public final PlayablePhoneme _AI;
    public final PlayablePhoneme _OI;
    public final PlayablePhoneme _V8;
    public final PlayablePhoneme _Vu;
    public final PlayablePhoneme _i6;
    public final PlayablePhoneme _Aw;
    public final PlayablePhoneme _oi;
    public final PlayablePhoneme _Vw;
    public final PlayablePhoneme _uA;
    public final PlayablePhoneme _uat;
    public final PlayablePhoneme _Ei;
    public final PlayablePhoneme _Ai;
    public final PlayablePhoneme _atU;
    public final PlayablePhoneme _uw;

    public PhonemeSet(PhonemeFileSet fileSet) {
        this.fs = fileSet;
        this._A = new SonorantPhoneme(this.fs._A);
        this._a = new SonorantPhoneme(this.fs._a);
        this._E = new SonorantPhoneme(this.fs._E);
        this._I = new SonorantPhoneme(this.fs._I);
        this._U = new SonorantPhoneme(this.fs._U, 0.12f, true);
        this._i = new SonorantPhoneme(this.fs._i);
        this._V = new SonorantPhoneme(this.fs._V);
        this._o = new SonorantPhoneme(this.fs._o);
        this._O = new SonorantPhoneme(this.fs._O);
        this._u = new SonorantPhoneme(this.fs._u);
        this._3 = new SonorantPhoneme(this.fs._3);
        this._at_1 = new SonorantPhoneme(this.fs._at_1);
        this._at_2 = new ObstruentPhoneme(this.fs._at_2);
        this._r$ = new SonorantPhoneme(this.fs._r$_1, 0.1f, false);
        this._m = new SonorantPhoneme(this.fs._m_1, 0.1f, false);
        this._n = new SonorantPhoneme(this.fs._n_1, 0.1f, false);
        this._l = new SonorantPhoneme(this.fs._l_1, 0.13f, false);
        this._f = new SonorantPhoneme(this.fs._f_1, 0.07f, false);
        this._v = new SonorantPhoneme(this.fs._v_2, 0.1f, false);
        this._s = new SonorantPhoneme(this.fs._s_1, 0.1f, false);
        this._S = new SonorantPhoneme(this.fs._S_1, 0.1f, false);
        this._z = new SonorantPhoneme(this.fs._z_1, 0.1f, false);
        this._Z = new SonorantPhoneme(this.fs._Z_1, 0.1f, false);
        this._w = new SonorantPhoneme(this.fs._w_1, 0.1f, false);
        this._T = new SonorantPhoneme(this.fs._T_1, 0.1f, false);
        this._x = new SonorantPhoneme(this.fs._x_1, 0.1f, false);
        this._D = new SonorantPhoneme(this.fs._D_1, 0.1f, false);
        this._h = new SonorantPhoneme(this.fs._h_1, 0.1f, false);
        this._N = new SonorantPhoneme(this.fs._N_1, 0.1f, false);
        this._b = new ObstruentPhoneme(this.fs._b_2, 0.03f);
        this._p = new ObstruentPhoneme(this.fs._p_2, 0.05f);
        this._g = new ObstruentPhoneme(this.fs._g_2);
        this._dZ = new ObstruentPhoneme(this.fs._dZ_2, 0.05f);
        this._d = new ObstruentPhoneme(this.fs._d_2, 0.05f);
        this._t = new ObstruentPhoneme(this.fs._t_2, 0.05f);
        this._k = new ObstruentPhoneme(this.fs._k_2, 0.05f);
        this._tS = new ObstruentPhoneme(this.fs._tS_2, 0.05f);
        this._j = new ObstruentPhoneme(this.fs._j_2, 0.05f);
        this._EI = new DiphthongPhoneme(this._E, this._i);
        this._AI = new DiphthongPhoneme(this._A, this._i);
        this._OI = new DiphthongPhoneme(this._O, this._i);
        this._V8 = new DiphthongPhoneme(this._V, this._U);
        this._Vu = new DiphthongPhoneme(this._V, this._u);
        this._i6 = new DiphthongPhoneme(this._i, this._u);
        this._Aw = new DiphthongPhoneme(this._A, this._w);
        this._oi = new DiphthongPhoneme(this._o, this._i);
        this._Vw = new DiphthongPhoneme(this._V, this._w);
        this._uA = new DiphthongPhoneme(this._u, this._A);
        this._uat = new DiphthongPhoneme(this._u, this._at_1);
        this._Ei = new DiphthongPhoneme(this._E, this._i);
        this._Ai = new DiphthongPhoneme(this._A, this._i);
        this._atU = new DiphthongPhoneme(this._at_1, this._U);
        this._uw = new DiphthongPhoneme(this._u, this._w);
    }

    public PlayablePhoneme toSound2(int c1, int c2) {
        return switch (c1) {
            case 73 -> {
                switch (c2) {
                    case 89: {
                        yield this._i;
                    }
                    case 72: 
                    case 88: {
                        yield this._I;
                    }
                }
                yield this.SPACE;
            }
            case 69 -> {
                switch (c2) {
                    case 72: {
                        yield this._E;
                    }
                    case 82: {
                        yield this._3;
                    }
                    case 89: {
                        yield this._EI;
                    }
                }
                yield this.SPACE;
            }
            case 65 -> {
                switch (c2) {
                    case 69: 
                    case 88: {
                        yield this._a;
                    }
                    case 65: {
                        yield this._O;
                    }
                    case 72: {
                        yield this._at_1;
                    }
                    case 79: {
                        yield this._o;
                    }
                    case 87: {
                        yield this._Aw;
                    }
                    case 89: {
                        yield this._AI;
                    }
                }
                yield this.SPACE;
            }
            case 85 -> {
                switch (c2) {
                    case 72: {
                        yield this._U;
                    }
                    case 88: {
                        yield this._u;
                    }
                    case 87: {
                        yield this._u;
                    }
                }
                yield this.SPACE;
            }
            case 79 -> {
                switch (c2) {
                    case 72: {
                        yield this._atU;
                    }
                    case 73: {
                        yield this._OI;
                    }
                    case 87: {
                        yield this._Vw;
                    }
                }
                yield this.SPACE;
            }
            case 78 -> {
                if (c2 == 88) {
                    yield this._N;
                }
                yield this._n;
            }
            case 90 -> {
                if (c2 == 72) {
                    yield this._Z;
                }
                yield this._z;
            }
            case 68 -> {
                if (c2 == 72) {
                    yield this._D;
                }
                yield this._d;
            }
            case 83 -> {
                if (c2 == 72) {
                    yield this._S;
                }
                yield this._s;
            }
            case 84 -> {
                if (c2 == 72) {
                    yield this._T;
                }
                yield this._t;
            }
            case 67 -> {
                if (c2 == 72) {
                    yield this._tS;
                }
                yield this.SPACE;
            }
            case 82 -> this._r$;
            case 76 -> this._l;
            case 87 -> this._w;
            case 89 -> this._j;
            case 77 -> this._m;
            case 66 -> this._b;
            case 71 -> this._g;
            case 74 -> this._dZ;
            case 86 -> this._v;
            case 70 -> this._f;
            case 80 -> this._p;
            case 75 -> this._k;
            case 72 -> this._h;
            default -> this.SPACE;
        };
    }

    public PlayablePhoneme toSound(String sam) {
        return switch (sam) {
            case "IY" -> this._i;
            case "IH" -> this._I;
            case "EH" -> this._E;
            case "AE" -> this._a;
            case "AA" -> this._O;
            case "AH" -> this._at_1;
            case "AO" -> this._o;
            case "OH" -> this._atU;
            case "UH" -> this._U;
            case "UX" -> this._u;
            case "ER" -> this._3;
            case "AX" -> this._a;
            case "IX" -> this._I;
            case "EY" -> this._EI;
            case "AY" -> this._AI;
            case "OY" -> this._OI;
            case "AW" -> this._Aw;
            case "OW" -> this._Vw;
            case "UW" -> this._uw;
            case "UU" -> this._at_1;
            case "R" -> this._r$;
            case "L" -> this._l;
            case "W" -> this._w;
            case "WH" -> this._w;
            case "Y" -> this._j;
            case "M" -> this._m;
            case "N" -> this._n;
            case "NX" -> this._N;
            case "B" -> this._b;
            case "D" -> this._d;
            case "G" -> this._g;
            case "J" -> this._dZ;
            case "Z" -> this._z;
            case "ZH" -> this._Z;
            case "V" -> this._v;
            case "DH" -> this._D;
            case "S" -> this._s;
            case "SH" -> this._S;
            case "F" -> this._f;
            case "TH" -> this._T;
            case "P" -> this._p;
            case "T" -> this._t;
            case "K" -> this._k;
            case "X" -> this._x;
            case "CH" -> this._tS;
            case "H" -> this._h;
            default -> null;
        };
    }
}

