/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepspeak.parser;

import com.neep.neepspeak.NEEPSpeakException;
import com.neep.neepspeak.mouth.phoneme.PlayablePhoneme;
import com.neep.neepspeak.parser.PhonemeAppender;
import com.neep.neepspeak.parser.Phonemiser;
import com.neep.neepspeak.parser.RuleParser;
import com.neep.neepspeak.phoneme.PhonemeSet;
import java.util.List;
import java.util.regex.Pattern;

public class RuleBuilder {
    private final PhonemeSet ps;
    private Match prefix;
    private Match match;
    private Match suffix;
    private Apply action;

    private RuleBuilder(PhonemeSet ps) {
        this.ps = ps;
    }

    public static RuleBuilder start(PhonemeSet ps) {
        return new RuleBuilder(ps);
    }

    public RuleBuilder prefix(int length, String pattern) {
        this.prefix = new Match(length, pattern);
        return this;
    }

    public RuleBuilder prefix(String pattern) {
        return this.prefix(pattern.length(), pattern);
    }

    public RuleBuilder suffix(int length, String pattern) {
        this.suffix = new Match(length, pattern);
        return this;
    }

    public RuleBuilder vowelSuffix() {
        this.suffix(1, "[aeiouy]");
        return this;
    }

    public RuleBuilder endWord() {
        this.suffix(1, "\u0000");
        return this;
    }

    public RuleBuilder endWordPlural() {
        this.suffix(2, "(\u0000|s\u0000)");
        return this;
    }

    public RuleBuilder suffix(String pattern) {
        return this.suffix(pattern.length(), pattern);
    }

    public RuleBuilder match(int length, String pattern) {
        this.match = new Match(length, pattern);
        return this;
    }

    public RuleBuilder match(String pattern) {
        return this.match(pattern.length(), pattern);
    }

    public RuleBuilder phonemes(PlayablePhoneme ... phonemes) {
        this.action = (a, ps, s, i) -> a.append(phonemes);
        return this;
    }

    public RuleBuilder phonemes(String phonemes) {
        try {
            List<PlayablePhoneme> parsed = RuleParser.parseSamPhonetic(phonemes, this.ps);
            this.action = (a, ps, s, i) -> a.append(parsed);
        }
        catch (NEEPSpeakException e) {
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    public RuleBuilder phonemes(Apply action) {
        this.action = action;
        return this;
    }

    public static Phonemiser.Rule build(Match prefix, Match match, Match suffix, Apply action) {
        if (action == null || match == null) {
            throw new IllegalStateException("No action specified");
        }
        String regex = "^" + (prefix != null ? prefix.regex : "") + match.regex + (suffix != null ? suffix.regex : "");
        Pattern pattern = Pattern.compile(regex);
        Pattern matchPattern = Pattern.compile("^" + match.regex);
        return new StandardRule(prefix != null ? prefix.length : 0, match.length, suffix != null ? suffix.length : 0, pattern, matchPattern, action);
    }

    public Phonemiser.Rule build() {
        return RuleBuilder.build(this.prefix, this.match, this.suffix, this.action);
    }

    public record Match(int length, String regex) {
        public static final Match EMPTY = new Match(0, "");
    }

    public static interface Apply {
        public void apply(PhonemeAppender var1, PhonemeSet var2, String var3, int var4);
    }

    public record StandardRule(int prefixLength, int matchLength, int suffixLength, Pattern pattern, Pattern match, Apply action) implements Phonemiser.Rule
    {
        @Override
        public int apply(PhonemeAppender append, PhonemeSet ps, String word, int i, int c, boolean start) {
            if (i - this.prefixLength < 0 || i + this.matchLength > word.length()) {
                return 0;
            }
            int substringEnd = Math.min(word.length(), i + this.matchLength + this.suffixLength);
            String substring = word.substring(i - this.prefixLength, substringEnd);
            if (this.pattern.asPredicate().test(substring)) {
                String matchString = word.substring(i, i + this.matchLength);
                if (this.match.asPredicate().test(matchString)) {
                    Phonemiser.debug(this.pattern.pattern() + " - " + substring + " " + Character.toString(c));
                    this.action.apply(append, ps, word, i);
                    return this.matchLength;
                }
            }
            return 0;
        }
    }
}

