/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepspeak.parser;

import com.neep.neepspeak.PhonemeList;
import com.neep.neepspeak.mouth.phoneme.Phonemes;
import com.neep.neepspeak.mouth.phoneme.PlayablePhoneme;
import com.neep.neepspeak.parser.ConsonantRule;
import com.neep.neepspeak.parser.DoubleConsonantRule;
import com.neep.neepspeak.parser.PhonemeAppender;
import com.neep.neepspeak.parser.RuleBuilder;
import com.neep.neepspeak.parser.RuleParser;
import com.neep.neepspeak.parser.Rules;
import com.neep.neepspeak.parser.VowelUtil;
import com.neep.neepspeak.phoneme.PhonemeSet;
import java.util.ArrayList;
import java.util.List;

public class Phonemiser
implements Phonemes {
    public static final String ANY_CONSONANT = "[bcdfghjklmnpqrstvwxz]";
    public static final String ANY_VOWEL = "[aeiouy]";
    public static final String ANY_FRONT_VOWEL = "[eiy]";
    public static final String ANY_LIQUID = "[rl]";
    public static final String NOT_VOWEL_PRE = "(\u0000|[^aeiouy])";
    public static final String NOT_VOWEL_SUF = "(\u0000|[^aeiouy])";
    public static final String END_OR_PLURAL = "(\u0000|s\u0000)";
    private final List<Rule> rules = new ArrayList<Rule>();
    private final PhonemeSet ps;

    public static void debug(String string) {
    }

    public Phonemiser(PhonemeSet phonemeSet) {
        this.ps = phonemeSet;
    }

    public <T extends Rule> void addRule(T t) {
        this.rules.add(t);
    }

    public void addRule(String rule, String phonemes) {
        this.addRule(RuleParser.parseRule(rule, phonemes, this.ps));
    }

    public void addRule(String[] rules) {
        if (rules.length % 2 != 0) {
            throw new IllegalArgumentException("rule array must consist of rule and phoneme pairs");
        }
        for (int i = 0; i < rules.length / 2; ++i) {
            this.addRule(rules[2 * i], rules[2 * i + 1]);
        }
    }

    public PhonemeList process(String input) {
        String[] words = input.split(" ");
        ArrayList<PlayablePhoneme> phonemes = new ArrayList<PlayablePhoneme>();
        PhonemeAppender appender = new PhonemeAppender(phonemes);
        for (String string : words) {
            String string2 = "\u0000" + string.toLowerCase() + "\u0000";
            block1: for (int i = 0; i < string2.length(); ++i) {
                boolean start = i == 0;
                int c = string2.codePointAt(i);
                if (c == 0) continue;
                for (Rule rule : this.rules) {
                    int advance = rule.apply(appender, this.ps, string2, i, c, start);
                    if (advance <= 0) continue;
                    i += advance - 1;
                    continue block1;
                }
            }
            appender.append(this.ps.SPACE);
            Phonemiser.debug("");
        }
        phonemes.add(END);
        Phonemiser.debug(((Object)phonemes).toString());
        return new PhonemeList(phonemes);
    }

    public void setupDefaultRules() {
        this.addRule("<ta>ble", "TEY");
        this.addRule(RuleBuilder.start(this.ps).prefix("\u0000").match("th").suffix("(is|ey|em|ese|at|ose|ou|ee|y|ine|an|ere|ence|ither|ough|us)\u0000").phonemes("DH").build());
        this.addRule("\u0000<my>\u0000", "MAY");
        this.addRule("<get>\u0000", "GEHT");
        this.addRule("<fu>", "FIYUX");
        this.addRule("<4(sion|tion)>", "SHAHN");
        this.addRule("<nu>clear", "NIYUX");
        this.addRule("<ied>\u0000", "AEIYD");
        this.addRule(new String[]{"\u0000<i>\u0000", "AY", "\u0000<i'm>", "AYM", "<air>", "EHR", "\u0000<the>\u0000", "DHAH", "<wom>1[ae]", "WUHM", "<air>", "EHR", "<board>", "BAARD", "<hav>1[ei]", "HAEV", "<you>", "YUX", "<i>nate", "IH", "<i>fied", "IH", "\u0000<cu>2t[aeiouy]", "KIYUW", "<ie>nce", "IY", "<who>", "HUX", "<ever>", "EHVR", "<ghost>", "GOHST", "2[wt]h<ere>", "EHR", "\u0000h<ere>", "IHR", "<said>", "SEHD", "\u0000d<ou>", "AH", "g<i>n", "IH", "<max>", "MAHKS", "<enien>2[tc]", "IYNIYEHN", "<con>", "KAAN", "<ocity>", "AASIHTIY", "<ique>", "IYK", "<uwu>", "UWWUW", "<owo>", "OWWOW", "<blood>", "BLAHD", "<ally>", "AELAY", "<above>", "AHBAHV", "<ore>2(\u0000|s\u0000)", "AOR", "<ivity>", "IHVIHTIY"});
        Rules.defaultNumbers(this);
        this.addRule(new String[]{"<ch>", "CH", "<sh>", "SH", "<ph>", "F", "<th>", "TH", "<qu>", "KW", "<wr>", "R", "<wh>o", "H", "<wh>", "W", "<xh>", "X", "<rh>", "R", "e<x>1[aeiouy]", "GZ", "<x>1", "KS"});
        this.addRule("<gh>1[aeiouy]", "G");
        this.addRule(RuleBuilder.start(this.ps).prefix(1, "(\u0000|[^aeiouy])").match(3, "[aeiouy]gh").phonemes(VowelUtil::longVowel).build());
        this.addRule("<gh>", "");
        this.addRule("<5[ao]ught>\u0000", "AOT");
        this.addRule("<ough>", "OW");
        this.addRule(new String[]{"<kn>", "N", "<gn>", "N", "<mn>", "N", "<pt>", "T", "<ps>", "S", "<tm>", "M"});
        this.addRule(RuleBuilder.start(this.ps).prefix(3, "\u0000..").match("y").phonemes("EY").build());
        this.addRule("<tm>", "M");
        this.addRule(RuleBuilder.start(this.ps).match("ey").phonemes("IY").build());
        this.addRule(RuleBuilder.start(this.ps).match("oy").phonemes("OY").build());
        this.addRule(RuleBuilder.start(this.ps).match("ay").phonemes("EY").build());
        this.addRule(RuleBuilder.start(this.ps).prefix(1, "(\u0000|[^aeiouy])").match("y").suffix(1, "(\u0000|[^aeiouy])").phonemes("IY").build());
        this.addRule(RuleBuilder.start(this.ps).match("stl").vowelSuffix().phonemes("SL").build());
        this.addRule(RuleBuilder.start(this.ps).match(2, "[ct]i").vowelSuffix().phonemes("SL").build());
        this.addRule(RuleBuilder.start(this.ps).match("tu").vowelSuffix().phonemes("TUW").build());
        this.addRule(RuleBuilder.start(this.ps).match("tu").suffix(1, ANY_LIQUID).phonemes("TUW").build());
        this.addRule(RuleBuilder.start(this.ps).match("si").suffix("o").phonemes("CH").build());
        this.addRule(RuleBuilder.start(this.ps).match("ssi").suffix("o").phonemes("CH").build());
        this.addRule(RuleBuilder.start(this.ps).match("s").suffix("ur").phonemes("ZH").build());
        this.addRule(RuleBuilder.start(this.ps).match("ss").suffix("ur").phonemes("ZH").build());
        this.addRule(RuleBuilder.start(this.ps).match("s").prefix(1, "[eiouy]").vowelSuffix().phonemes("Z").build());
        this.addRule(RuleBuilder.start(this.ps).match("al").suffix(1, "[rsm]").phonemes("AOL").build());
        this.addRule(RuleBuilder.start(this.ps).match("al").suffix(1, "l\u0000").phonemes("AOL").build());
        this.addRule(RuleBuilder.start(this.ps).match("alk").prefix(1, "[^\u0000]").phonemes("AOK").build());
        this.addRule(RuleBuilder.start(this.ps).match("ge").prefix(1, "[^\u0000]").suffix(1, "[oa]").phonemes("J").build());
        this.addRule(RuleBuilder.start(this.ps).match("c").suffix(1, ANY_FRONT_VOWEL).phonemes("S").build());
        this.addRule(RuleBuilder.start(this.ps).match("c").suffix(1, ANY_VOWEL).phonemes("K").build());
        this.addRule(RuleBuilder.start(this.ps).match("g").suffix(1, ANY_FRONT_VOWEL).phonemes("J").build());
        this.addRule(RuleBuilder.start(this.ps).match("g").suffix(1, ANY_VOWEL).phonemes("G").build());
        this.addRule(RuleBuilder.start(this.ps).match(2, "gu").prefix("\u0000").phonemes("G").build());
        this.addRule(RuleBuilder.start(this.ps).match(3, "gue\u0000").phonemes("G").build());
        this.addRule(RuleBuilder.start(this.ps).match(2, "le").prefix(1, ANY_CONSONANT).suffix(2, END_OR_PLURAL).phonemes("AHL").build());
        this.addRule(RuleBuilder.start(this.ps).match(2, "re").prefix(1, ANY_CONSONANT).suffix(2, END_OR_PLURAL).phonemes("AHR").build());
        this.addRule(RuleBuilder.start(this.ps).match("ind").endWordPlural().phonemes("AYND").build());
        this.addRule(RuleBuilder.start(this.ps).match("o").suffix(2, "f[bcdfghjklmnpqrstvwxz]").phonemes("AA").build());
        this.addRule(RuleBuilder.start(this.ps).match("wa").suffix(2, "([tdns]|th)").phonemes("WAA").build());
        this.addRule(RuleBuilder.start(this.ps).match("u").suffix(3, "([l]|sh|tch)").phonemes("UH").build());
        this.addRule(RuleBuilder.start(this.ps).match(2, "[eiu]r").phonemes("R").build());
        this.addRule(RuleBuilder.start(this.ps).match(1, ANY_VOWEL).suffix(2, "[bcdfghjklmnpqrstvwxz]{2}").phonemes(VowelUtil::shortVowel).build());
        this.addRule(RuleBuilder.start(this.ps).match(1, ANY_VOWEL).suffix(2, "[bcdfghjklmnpqrstvwxz]\u0000").phonemes(VowelUtil::shortVowel).build());
        this.addRule(RuleBuilder.start(this.ps).match(1, ANY_VOWEL).suffix(3, "(\u0000|[^aeiouy])[aeiouy]").phonemes(VowelUtil::longVowel).build());
        this.addRule(RuleBuilder.start(this.ps).match("e").suffix("\u0000").phonemes(new PlayablePhoneme[0]).build());
        this.addRule(RuleBuilder.start(this.ps).match(2, "i[aeiou]").prefix(2, "\u0000.").phonemes("AYAH").build());
        this.addRule(RuleBuilder.start(this.ps).match(2, "i[aeiou]").prefix(3, "\u0000..").phonemes("AYAH").build());
        this.addRule(RuleBuilder.start(this.ps).match(2, "ow\u0000").phonemes("OW").build());
        this.addRule("<oo>k", "UH");
        this.addRule("s<ei>", "IY");
        this.addRule("<ie>\u0000", "AY");
        this.addRule("<oul>d", "UH");
        this.addRule(RuleBuilder.start(this.ps).match("eau").phonemes("OW").build());
        this.addRule("<ai>", "EY");
        this.addRule("<2aw|au>", "AO");
        this.addRule("<2ee|ea>", "IY");
        this.addRule(RuleBuilder.start(this.ps).match("eo").phonemes("IYAH").build());
        this.addRule(RuleBuilder.start(this.ps).match(2, "eu|ew").phonemes("IYUW").build());
        this.addRule(RuleBuilder.start(this.ps).match("ei").phonemes("IY").build());
        this.addRule(RuleBuilder.start(this.ps).match(2, "oa|oe").phonemes("OW").build());
        this.addRule(RuleBuilder.start(this.ps).match("oo").phonemes("UX").build());
        this.addRule(RuleBuilder.start(this.ps).match(2, "ou|aw").phonemes("AW").build());
        this.addRule(RuleBuilder.start(this.ps).match(2, "oi").phonemes("OY").build());
        this.addRule(RuleBuilder.start(this.ps).match("ua").phonemes("IYUW").build());
        this.addRule(RuleBuilder.start(this.ps).match(2, "ue|ui").phonemes("IYUW").build());
        this.addRule("\u0000<y>", "Y");
        this.addRule(RuleBuilder.start(this.ps).match("[ai]ble").prefix(1, "[^\u0000]").endWord().phonemes("AHBL").build());
        this.addRule(RuleBuilder.start(this.ps).match("lion").prefix(1, ".").endWord().phonemes("LAYAHN").build());
        this.addRule(RuleBuilder.start(this.ps).match("nion").prefix(1, ".").endWord().phonemes("NAYAHN").build());
        this.addRule(RuleBuilder.start(this.ps).match(1, "[bn]").suffix("\u0000").prefix(1, "m").phonemes(new PlayablePhoneme[0]).build());
        this.addRule(RuleBuilder.start(this.ps).match(1, "a").endWord().phonemes("AH").build());
        this.addRule(RuleBuilder.start(this.ps).match(1, "e").endWord().phonemes("AH").build());
        this.addRule(RuleBuilder.start(this.ps).match(1, "i").endWord().phonemes("IY").build());
        this.addRule(RuleBuilder.start(this.ps).match(1, "o").endWord().phonemes("OW").build());
        this.addRule(RuleBuilder.start(this.ps).match(1, "u").endWord().phonemes("UX").build());
        this.addRule(RuleBuilder.start(this.ps).match("io").phonemes("IYOW").build());
        this.addRule(RuleBuilder.start(this.ps).match("wor").vowelSuffix().phonemes("WUXR").build());
        this.addRule(RuleBuilder.start(this.ps).match("wor").phonemes("WAO").build());
        this.addRule(new DoubleConsonantRule());
        this.addRule(new ConsonantRule());
    }

    public PhonemeSet getPhonemeSet() {
        return this.ps;
    }

    public static interface Rule {
        public int apply(PhonemeAppender var1, PhonemeSet var2, String var3, int var4, int var5, boolean var6);
    }
}

