/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepspeak.mouth.phoneme;

import com.neep.neepspeak.audio.AudioComponent;
import com.neep.neepspeak.audio.BiquadFilter2;
import com.neep.neepspeak.mouth.Waveforms;
import com.neep.neepspeak.mouth.phoneme.PlayablePhoneme;
import com.neep.neepspeak.util.SampleBuffer;
import com.neep.neepspeak.util.SampleInfo;

public class VowelA
implements PlayablePhoneme,
AudioComponent {
    private SampleInfo info;
    private BiquadFilter2 f1;
    private BiquadFilter2 f2;
    private BiquadFilter2 f3;
    private SampleBuffer b1;
    private SampleBuffer b2;
    private SampleBuffer b3;

    @Override
    public void init(SampleInfo info) {
        this.info = info;
        this.f1 = new BiquadFilter2(info.fs());
        this.f2 = new BiquadFilter2(info.fs());
        this.f3 = new BiquadFilter2(info.fs());
        float q = 2.0f;
        this.f1.setLowpass(700.0f, q);
        this.f2.setLowpass(1220.0f, q);
        this.f3.setLowpass(2600.0f, q);
        this.b1 = new SampleBuffer(info.frameSize());
        this.b2 = new SampleBuffer(info.frameSize());
        this.b3 = new SampleBuffer(info.frameSize());
    }

    @Override
    public void processBuffer(SampleBuffer sb, PlayablePhoneme.PlayContext context) {
        float f0 = 140.0f;
        int nharm = (int)(this.info.fs() / 2.0f / f0);
        Waveforms.impulseTrain(sb, this.info.fs(), f0, nharm, 0.5f);
        int size = sb.regionSize();
        sb.copyInto(this.b1, size);
        sb.copyInto(this.b2, size);
        sb.copyInto(this.b3, size);
        this.f1.process(this.b1);
        this.f2.process(this.b2);
        this.f3.process(this.b3);
        sb.clearRegion();
        this.b1.addInto(sb, size);
        this.b2.addInto(sb, size);
        this.b3.addInto(sb, size);
    }

    @Override
    public float length(PlayablePhoneme.PlayContext ctx) {
        return 0.2f;
    }

    @Override
    public float leadIn() {
        return 0.0f;
    }

    @Override
    public float tailOut() {
        return 0.0f;
    }
}

