/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepspeak.mouth.phoneme;

import com.neep.neepspeak.audio.SoundData;
import com.neep.neepspeak.audio.SoundDataProvider;
import com.neep.neepspeak.mouth.phoneme.PlayablePhoneme;
import com.neep.neepspeak.util.SampleBuffer;
import com.neep.neepspeak.util.SampleInfo;

public class SonorantPhoneme
implements PlayablePhoneme {
    private final SoundData data;
    private final SoundDataProvider entry;
    private final float length;
    private boolean crossfade;

    public SonorantPhoneme(SoundDataProvider entry, float length, boolean crossfade) {
        this.data = entry.get();
        this.entry = entry;
        this.length = length;
        this.crossfade = crossfade;
    }

    public SonorantPhoneme(SoundDataProvider entry) {
        this(entry, 0.1f, true);
    }

    @Override
    public void processBuffer(SampleBuffer sb, PlayablePhoneme.PlayContext ctx) {
        int offset = ctx.clockN();
        int samplesToFill = Math.min(sb.regionSize(), this.data.data().length - offset);
        if (samplesToFill > 0) {
            sb.fillFrom(this.data.data(), offset, sb.startSample, samplesToFill);
        }
    }

    @Override
    public float length(PlayablePhoneme.PlayContext ctx) {
        return this.length;
    }

    @Override
    public float leadIn() {
        return this.crossfade ? 0.01f : 0.0f;
    }

    @Override
    public float tailOut() {
        return 0.01f;
    }

    @Override
    public void init(SampleInfo info) {
    }

    public String toString() {
        return "[" + this.entry.name() + "]";
    }
}

