/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepspeak.mouth.phoneme;

import com.neep.neepspeak.audio.SoundData;
import com.neep.neepspeak.audio.SoundDataProvider;
import com.neep.neepspeak.mouth.phoneme.PlayablePhoneme;
import com.neep.neepspeak.util.SampleBuffer;
import com.neep.neepspeak.util.SampleInfo;

public class ObstruentPhoneme
implements PlayablePhoneme {
    private final SoundData data;
    private final SoundDataProvider entry;
    private final float length;

    public ObstruentPhoneme(SoundDataProvider entry, float length) {
        this.data = entry.get();
        this.entry = entry;
        this.length = length;
    }

    public ObstruentPhoneme(SoundDataProvider entry) {
        this(entry, 0.1f);
    }

    @Override
    public void processBuffer(SampleBuffer sb, PlayablePhoneme.PlayContext ctx) {
        int offset = ctx.clockN();
        int samplesToFill = Math.min(sb.regionSize(), this.data.data().length - offset);
        if (samplesToFill > 0) {
            sb.fillFrom(this.data.data(), offset, sb.startSample, samplesToFill);
        }
    }

    @Override
    public float length(PlayablePhoneme.PlayContext ctx) {
        return this.length;
    }

    @Override
    public float leadIn() {
        return 0.0f;
    }

    @Override
    public float tailOut() {
        return 0.0f;
    }

    @Override
    public void init(SampleInfo info) {
    }

    public String toString() {
        return "[" + this.entry.name() + "]";
    }
}

