/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepspeak.mouth.phoneme;

import com.neep.neepspeak.audio.BiquadFilter2;
import com.neep.neepspeak.mouth.ASR;
import com.neep.neepspeak.mouth.Waveforms;
import com.neep.neepspeak.mouth.phoneme.PlayablePhoneme;
import com.neep.neepspeak.util.SampleBuffer;
import com.neep.neepspeak.util.SampleInfo;

public class FricativeTest
implements PlayablePhoneme {
    private final ASR asr = new ASR(0.0f, 0.0f, 0.01f);
    private final BiquadFilter2 filter = new BiquadFilter2(44100.0f);

    public FricativeTest() {
        this.filter.setPeak(1000.0f, 5.0f);
    }

    @Override
    public void processBuffer(SampleBuffer sb, PlayablePhoneme.PlayContext context) {
        Waveforms.whiteNoise(sb);
        this.filter.process(sb);
        for (int i = 0; i < sb.regionSize(); ++i) {
            int n = context.clockN() + i;
            float a = this.asr.sample(n, 44100.0f);
            sb.data[sb.startSample + i] = sb.data[sb.startSample + i] * a;
        }
    }

    @Override
    public float length(PlayablePhoneme.PlayContext ctx) {
        return 0.01f;
    }

    @Override
    public float leadIn() {
        return 0.0f;
    }

    @Override
    public float tailOut() {
        return 0.0f;
    }

    @Override
    public void init(SampleInfo info) {
    }
}

