/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepspeak.mouth;

import com.neep.neepspeak.mouth.ASR;
import com.neep.neepspeak.util.SampleBuffer;

public class Waveforms {
    public static final int MAX_AMPLITUDE = 0x3FFFFFFF;
    public static final float SAMPLE_RATE = 44100.0f;

    public static void vowelAa(SampleBuffer sb, float fs) {
        float f0 = 700.0f;
        float f1 = 1220.0f;
        float f2 = 2600.0f;
        for (int i = sb.startSample; i < sb.endSample; ++i) {
            float thing = fs / 440.0f;
            double angle = (float)i / thing % 1.0f;
            sb.put(i, (float)angle);
        }
    }

    public static void sawtooth(SampleBuffer sb, float fs, float f0, float amp) {
        for (int i = sb.startSample; i < sb.endSample; ++i) {
            float thing = fs / f0;
            double angle = (float)i / thing % 1.0f;
            sb.put(i, (float)((angle - 0.5) * 2.0 * (double)amp));
        }
    }

    public static void impulseTrain(SampleBuffer sb, float fs, float f0, int harmonics, float gain) {
        for (int i = 0; i < harmonics; ++i) {
            float w0T = (float)(Math.PI * 2 * (double)f0 / (double)fs);
            int n = sb.startSample;
            while (n < sb.endSample) {
                double angle = (float)(n * i) * w0T;
                int n2 = n++;
                sb.data[n2] = sb.data[n2] + (float)(Math.cos(angle) * (double)gain) / (float)harmonics;
            }
        }
    }

    public static void sine(SampleBuffer sb, float fs, float f0, float gain) {
        for (int i = sb.startSample; i < sb.endSample; ++i) {
            float thing = fs / f0;
            double angle = (double)((float)i / thing * 2.0f) * Math.PI;
            sb.put(i, (float)(Math.sin(angle) * (double)gain));
        }
    }

    public static void sineSweep(SampleBuffer sb, float fs, float f0, float f1, float gain) {
        float f = f0;
        float step = (f1 - f0) / (float)sb.regionSize();
        for (int i = sb.startSample; i < sb.endSample; ++i) {
            float thing = fs / f;
            double angle = (double)((float)i / thing * 2.0f) * Math.PI;
            sb.put(i, (float)(Math.sin(angle) * (double)gain));
            f += step;
        }
    }

    public static void sineSweep(SampleBuffer sb, float fs, float f0, float f1, int buckets, float gain) {
        float step = (f1 - f0) / (float)buckets;
        int size = sb.regionSize();
        int bucketSamples = size / buckets;
        float bucketTime = (float)bucketSamples / fs;
        float rise = 0.1f * bucketTime;
        ASR env = new ASR(rise, bucketTime - 2.0f * rise, rise);
        for (int i = sb.startSample; i < sb.endSample; ++i) {
            float amp = gain * env.sample((i - sb.startSample) % bucketSamples, fs);
            int bucket = (int)Math.floor((double)buckets * (double)i / (double)size);
            float f = (float)bucket * step;
            float thing = fs / f;
            double angle = (double)((float)i / thing * 2.0f) * Math.PI;
            sb.put(i, (float)(Math.sin(angle) * (double)amp));
        }
    }

    public static void sineSweep(SampleBuffer sb, float fs, float[] fRange, float gain) {
        for (int i = 0; i < sb.regionSize(); ++i) {
            float thing = fs / fRange[i];
            double angle = (double)((float)i / thing * 2.0f) * Math.PI;
            sb.put(sb.startSample + i, (float)(Math.sin(angle) * (double)gain));
        }
    }

    public static void whiteNoise(SampleBuffer sb) {
        for (int i = sb.startSample; i < sb.endSample; ++i) {
            sb.put(i, (float)(2.0 * (Math.random() - 0.5)));
        }
    }
}

