/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepspeak.mouth;

import com.neep.neepspeak.PhonemeList;
import com.neep.neepspeak.audio.AudioComponent;
import com.neep.neepspeak.mouth.phoneme.DiphthongPhoneme;
import com.neep.neepspeak.mouth.phoneme.Phonemes;
import com.neep.neepspeak.mouth.phoneme.PlayablePhoneme;
import com.neep.neepspeak.util.SampleBuffer;
import com.neep.neepspeak.util.SampleInfo;

public class Mouth
implements AudioComponent {
    private final PhonemeList list;
    private PlayingPhoneme currentPhoneme;
    private PlayingPhoneme nextPhoneme;
    int idx = 0;
    private SampleInfo info;
    private int crossfadeN;
    private SampleBuffer crossfadeBuffer;

    public Mouth(PhonemeList list) {
        this.list = list;
        this.currentPhoneme = new PlayingPhoneme(list.get(0));
        PlayablePhoneme playablePhoneme = this.currentPhoneme.phoneme;
        if (playablePhoneme instanceof DiphthongPhoneme) {
            DiphthongPhoneme diphthong = (DiphthongPhoneme)playablePhoneme;
            this.currentPhoneme = new PlayingPhoneme(diphthong.getP1());
            this.nextPhoneme = new PlayingPhoneme(diphthong.getP2());
            --this.idx;
        } else {
            this.nextPhoneme = new PlayingPhoneme(list.get(1));
        }
    }

    public boolean isDone() {
        return this.currentPhoneme != null && this.currentPhoneme.phoneme == Phonemes.END;
    }

    public void processBuffer(SampleBuffer sb) {
        int samplesThisTime;
        int crossfadeLength = 1500;
        for (int samplesRemaining = sb.regionSize(); samplesRemaining > 0; samplesRemaining -= samplesThisTime) {
            if (this.currentPhoneme == null) {
                ++this.idx;
                this.currentPhoneme = this.nextPhoneme;
                PlayablePhoneme playablePhoneme = this.currentPhoneme.phoneme;
                if (playablePhoneme instanceof DiphthongPhoneme) {
                    DiphthongPhoneme diphthong = (DiphthongPhoneme)playablePhoneme;
                    this.currentPhoneme = new PlayingPhoneme(diphthong.getP1());
                    this.nextPhoneme = new PlayingPhoneme(diphthong.getP2());
                    --this.idx;
                } else {
                    this.nextPhoneme = new PlayingPhoneme(this.list.get(this.idx + 1));
                }
                this.crossfadeN = 0;
            }
            if (this.currentPhoneme.phoneme == Phonemes.END) break;
            int lengthN = (int)(this.currentPhoneme.length() * this.info.fs());
            int phonemeRemainingN = lengthN - this.currentPhoneme.clockN;
            int crossfadeStartN = lengthN - crossfadeLength;
            samplesThisTime = Math.min(samplesRemaining, phonemeRemainingN);
            int chunkStart = sb.endSample - samplesRemaining;
            int cross = this.currentPhoneme.clockN + samplesThisTime - crossfadeStartN;
            int cross1 = Math.min(cross, samplesThisTime);
            boolean crossfade = crossfadeLength > 0 && this.currentPhoneme.phoneme.tailOut() != 0.0f && this.nextPhoneme.phoneme.leadIn() != 0.0f && cross > 0;
            boolean transitionThisTime = this.currentPhoneme.clockN + samplesThisTime >= lengthN;
            SampleBuffer subBuffer = new SampleBuffer(sb.data, chunkStart, chunkStart + samplesThisTime);
            this.currentPhoneme.processBuffer(subBuffer);
            if (crossfade) {
                int thisCrossfadeLength = Math.min(crossfadeLength, cross1);
                SampleBuffer sb1 = new SampleBuffer(new float[thisCrossfadeLength], 0, thisCrossfadeLength);
                this.nextPhoneme.processBuffer(sb1);
                this.nextPhoneme.clockN += thisCrossfadeLength;
                float a0 = (float)this.crossfadeN / (float)crossfadeLength;
                float a1 = (float)(this.crossfadeN + thisCrossfadeLength) / (float)crossfadeLength;
                sb1.applyRamp(a0, a1, 0, thisCrossfadeLength);
                this.crossfadeN += thisCrossfadeLength;
                sb.applyRamp(1.0f - a0, 1.0f - a1, subBuffer.endSample - thisCrossfadeLength, subBuffer.endSample);
                sb1.addInto(sb, sb1.startSample, subBuffer.endSample - thisCrossfadeLength, thisCrossfadeLength);
            }
            if (transitionThisTime) {
                this.currentPhoneme = null;
                continue;
            }
            this.currentPhoneme.clockN += samplesThisTime;
        }
    }

    @Override
    public void init(SampleInfo info) {
        this.info = info;
        this.list.init(info);
        this.crossfadeBuffer = new SampleBuffer(256);
    }

    private static class PlayingPhoneme
    implements PlayablePhoneme.PlayContext {
        public final PlayablePhoneme phoneme;
        public int clockN = 0;

        private PlayingPhoneme(PlayablePhoneme phoneme) {
            this.phoneme = phoneme;
        }

        public void processBuffer(SampleBuffer sb) {
            this.phoneme.processBuffer(sb, this);
        }

        @Override
        public int clockN() {
            return this.clockN;
        }

        public float length() {
            return this.phoneme.length(this);
        }

        public String toString() {
            return this.phoneme.toString();
        }
    }
}

