/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepspeak.audio;

import com.neep.neepspeak.audio.Filter;
import com.neep.neepspeak.util.SampleBuffer;

public class BiquadFilter2
implements Filter {
    private final float fs;
    private final float[] prevInput = new float[2];
    private final float[] prevOutput = new float[2];
    private float b0;
    private float b1;
    private float b2;
    private float a0;
    private float a1;
    private float a2;
    private float gain = 1.0f;

    public BiquadFilter2(float fs) {
        this.fs = fs;
    }

    private void normaliseCoefficients() {
        this.a1 /= this.a0;
        this.a2 /= this.a0;
        this.b0 /= this.a0;
        this.b1 /= this.a0;
        this.b2 /= this.a0;
    }

    public void setGain(float gainAbs) {
        this.gain = gainAbs;
    }

    public void setPeak(float fc, float q) {
        float omega = (float)(Math.PI * 2 * (double)fc / (double)this.fs);
        float sn = (float)Math.sin(omega);
        float cs = (float)Math.cos(omega);
        float alpha = sn / (2.0f * q);
        this.b0 = 1.0f + alpha * this.gain;
        this.b1 = -2.0f * cs;
        this.b2 = 1.0f - alpha * this.gain;
        this.a0 = 1.0f + alpha / this.gain;
        this.a1 = -2.0f * cs;
        this.a2 = 1.0f - alpha / this.gain;
        this.normaliseCoefficients();
    }

    public void setLowpass(float fc, float q) {
        float omega = (float)(Math.PI * 2 * (double)fc / (double)this.fs);
        float sn = (float)Math.sin(omega);
        float cs = (float)Math.cos(omega);
        float alpha = sn / (2.0f * q);
        float beta = (float)Math.sqrt(this.gain + this.gain);
        this.b0 = (1.0f - cs) / 2.0f;
        this.b1 = 1.0f - cs;
        this.b2 = (1.0f - cs) / 2.0f;
        this.a0 = 1.0f + alpha;
        this.a1 = -2.0f * cs;
        this.a2 = 1.0f - alpha;
        this.normaliseCoefficients();
    }

    @Override
    public void process(SampleBuffer sb) {
        for (int i = sb.startSample; i < sb.endSample; ++i) {
            float input = sb.data[i];
            float output = this.b0 * input + this.b1 * this.prevInput[0] + this.b2 * this.prevInput[1] - this.a1 * this.prevOutput[0] - this.a2 * this.prevOutput[1];
            this.prevInput[1] = this.prevInput[0];
            this.prevInput[0] = input;
            this.prevOutput[1] = this.prevOutput[0];
            this.prevOutput[0] = output;
            sb.data[i] = output;
        }
    }
}

