/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepspeak.audio;

import com.neep.neepspeak.audio.Filter;
import com.neep.neepspeak.util.SampleBuffer;

public class BiquadFilter
implements Filter {
    private final float fs;
    private final float[] prevX = new float[3];
    private final float[] prevY = new float[3];
    private float fc;
    private float a0;
    private float a1;
    private float a2;
    private float b0;
    private float b1;
    private float b2;

    public BiquadFilter(float fs) {
        this.fs = fs;
    }

    public void setLowpass(float fc, float q) {
        float k = (float)Math.tan(Math.PI * (double)fc / (double)this.fs);
        float kk = k * k;
        float denom = 1.0f / (kk * q + k + q);
        this.a1 = 2.0f * q * (kk - 1.0f) * denom;
        this.a2 = (kk * q - k + q) * denom;
        this.b0 = kk * q * denom;
        this.b1 = 2.0f * this.b0;
        this.b2 = this.b0;
    }

    public void setResonant(float fc, float radius, boolean normalize) {
        this.a2 = radius * radius;
        this.a1 = (float)((double)(-2.0f * radius) * Math.cos(Math.PI * 2 * (double)fc / (double)this.fs));
        if (normalize) {
            this.b0 = 0.5f - 0.5f * this.a2;
            this.b1 = 0.0f;
            this.b2 = -this.b0;
        } else {
            this.b0 = 1.0f;
            this.b1 = 0.0f;
            this.b2 = 0.0f;
        }
    }

    @Override
    public void process(SampleBuffer sb) {
        float g = 1.0f;
        for (int i = sb.startSample; i < sb.endSample; ++i) {
            this.prevX[0] = g * sb.data[i];
            float res = this.b0 * this.prevX[0] + this.b1 * this.prevX[1] + this.b2 * this.prevX[2];
            this.prevX[2] = this.prevX[1];
            this.prevX[1] = this.prevX[0];
            this.prevY[2] = this.prevY[1];
            this.prevY[1] = res -= this.a2 * this.prevY[2] + this.a1 * this.prevY[1];
            sb.data[i] = res;
        }
    }
}

