/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepspeak;

import com.neep.neepspeak.NEEPSpeakException;
import com.neep.neepspeak.PhonemeList;
import com.neep.neepspeak.audio.BiquadFilter2;
import com.neep.neepspeak.audio.SoundFiles;
import com.neep.neepspeak.mouth.Mouth;
import com.neep.neepspeak.parser.Phonemiser;
import com.neep.neepspeak.phoneme.PhonemeSet;
import com.neep.neepspeak.util.SampleBuffer;
import com.neep.neepspeak.util.SampleInfo;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class NEEPSpeak {
    public static AudioFormat initOutputFormat(float fs, int bytes) {
        int channels = 1;
        int sampleSizeInBits = bytes * 8;
        int frameSize = (sampleSizeInBits + 7) / 8 * channels;
        return new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, fs, sampleSizeInBits, channels, frameSize, fs, false);
    }

    public static void main(String[] args) throws LineUnavailableException, NEEPSpeakException {
        float fs = 44100.0f;
        int bytes = 2;
        AudioFormat af = NEEPSpeak.initOutputFormat(fs, bytes);
        SoundFiles.preload();
        SourceDataLine sdl = AudioSystem.getSourceDataLine(af);
        sdl.open();
        sdl.start();
        int longFrameSize = 1024;
        int lenSamples = (int)(fs * 4.0f / (float)longFrameSize) * longFrameSize;
        SampleBuffer mainSb = new SampleBuffer(new float[lenSamples], 0, lenSamples);
        Phonemiser phonemiser = new Phonemiser(PhonemeSet.NORMAL);
        phonemiser.setupDefaultRules();
        PhonemeList phonemes = phonemiser.process("whole whatever wherever");
        Mouth mouth = new Mouth(phonemes);
        mouth.init(new SampleInfo(fs, mainSb.regionSize()));
        int frames = lenSamples / longFrameSize;
        for (int i = 0; i < frames; ++i) {
            SampleBuffer sb = new SampleBuffer(mainSb.data, i * longFrameSize, (i + 1) * longFrameSize);
            mouth.processBuffer(sb);
        }
        ByteBuffer convert = NEEPSpeak.floatsToOutput(mainSb.data, bytes, af.isBigEndian(), ByteBuffer::allocate);
        sdl.write(convert.array(), 0, lenSamples * bytes);
        sdl.drain();
        sdl.stop();
    }

    public static void main1(String[] args) throws LineUnavailableException {
        float fs = 44100.0f;
        int lenSamples = (int)fs * 2;
        boolean play = false;
        AudioFormat af = NEEPSpeak.initOutputFormat(fs, 4);
        SourceDataLine sdl = AudioSystem.getSourceDataLine(af);
        if (play) {
            sdl.open();
            sdl.start();
        }
        SampleBuffer sb = new SampleBuffer(new float[lenSamples], 0, lenSamples);
        BiquadFilter2 biquad2 = new BiquadFilter2(fs);
        biquad2.setLowpass(2000.0f, 2.0f);
        SampleInfo info = new SampleInfo(44100.0f, sb.regionSize());
        if (play) {
            int bytes = 4;
            ByteBuffer convert = NEEPSpeak.floatsToOutput(sb.data, bytes, true, ByteBuffer::allocate);
            sdl.write(convert.array(), 0, lenSamples * bytes);
            sdl.drain();
            sdl.stop();
        }
    }

    public static ByteBuffer floatsToOutput(float[] floats, int bytes, boolean bigEndian, Function<Integer, ByteBuffer> allocate) {
        ByteBuffer convert;
        block3: {
            block2: {
                convert = allocate.apply(floats.length * bytes);
                convert.order(bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
                if (bytes != 2) break block2;
                for (int i = 0; i < floats.length; ++i) {
                    convert.putShort(i * bytes, (short)((double)floats[i] * 32767.0));
                }
                break block3;
            }
            if (bytes != 4) break block3;
            for (int i = 0; i < floats.length; ++i) {
                convert.putInt(i * bytes, (int)((double)floats[i] * 2.147483647E9));
            }
        }
        return convert;
    }

    public static float[] linearRange(float f0, float f1, int size) {
        float step = (f1 - f0) / (float)size;
        float[] res = new float[size];
        float f = f0;
        for (int i = 0; i < size; ++i) {
            res[i] = f;
            f += step;
        }
        return res;
    }

    public static float[] linearRange(float f0, float f1, int buckets, int size) {
        float step = (f1 - f0) / (float)buckets;
        float[] res = new float[size];
        for (int i = 0; i < size; ++i) {
            float f;
            int bucket = (int)Math.floor((double)buckets * (double)i / (double)size);
            res[i] = f = (float)bucket * step;
        }
        return res;
    }

    public static int[] concat(byte[] b) {
        int[] result = new int[b.length / 2];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (short)(b[2 * i] << 8 & 0xFF00 | b[2 * i + 1] & 0xFF);
        }
        return result;
    }

    public static int[] range(int size) {
        return IntStream.range(0, size).toArray();
    }
}

