/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.ftech_robots.dynamicPaths;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2261;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_4863;
import org.jetbrains.annotations.Nullable;
import uk.co.cablepost.ftech_robots.models.BlockPosAndState;

public class DynamicPath {
    private final class_1937 world;
    private final class_2338 pos1;
    private final class_2338 pos2;

    public DynamicPath(class_1937 world, class_2338 pos1, class_2338 pos2) {
        this.world = world;
        this.pos1 = pos1;
        this.pos2 = pos2;
    }

    private int getHalfWidth(boolean diagonal) {
        return diagonal ? 3 : 5;
    }

    private int getTunnelHeight() {
        return 8;
    }

    private Optional<class_2382> getNextDirection(class_2338 current) {
        class_2382 toRet = new class_2382(0, 0, 0);
        if (current.method_10263() > this.pos2.method_10263()) {
            toRet = toRet.method_34592(-1, 0, 0);
        }
        if (current.method_10263() < this.pos2.method_10263()) {
            toRet = toRet.method_34592(1, 0, 0);
        }
        if (current.method_10264() > this.pos2.method_10264()) {
            toRet = toRet.method_34592(0, -1, 0);
        }
        if (current.method_10264() < this.pos2.method_10264()) {
            toRet = toRet.method_34592(0, 1, 0);
        }
        if (current.method_10260() > this.pos2.method_10260()) {
            toRet = toRet.method_34592(0, 0, -1);
        }
        if (current.method_10260() < this.pos2.method_10260()) {
            toRet = toRet.method_34592(0, 0, 1);
        }
        if (toRet.method_10263() == 0 && toRet.method_10260() == 0) {
            return Optional.empty();
        }
        return Optional.of(toRet);
    }

    private class_2382 getLeftDirection(class_2382 direction) {
        if (direction.method_10263() == -1 && direction.method_10260() == -1) {
            return new class_2382(1, 0, -1);
        }
        if (direction.method_10263() == -1 && direction.method_10260() == 0) {
            return new class_2382(0, 0, 1);
        }
        if (direction.method_10263() == -1 && direction.method_10260() == 1) {
            return new class_2382(1, 0, 1);
        }
        if (direction.method_10263() == 0 && direction.method_10260() == -1) {
            return new class_2382(-1, 0, 0);
        }
        if (direction.method_10263() == 0 && direction.method_10260() == 1) {
            return new class_2382(1, 0, 0);
        }
        if (direction.method_10263() == 1 && direction.method_10260() == -1) {
            return new class_2382(-1, 0, -1);
        }
        if (direction.method_10263() == 1 && direction.method_10260() == 0) {
            return new class_2382(0, 0, -1);
        }
        if (direction.method_10263() == 1 && direction.method_10260() == 1) {
            return new class_2382(1, 0, -1);
        }
        throw new RuntimeException("Unknown how to get left of offset: " + direction.method_23854());
    }

    private class_2382 get45LeftDirection(class_2382 direction) {
        if (direction.method_10263() == -1 && direction.method_10260() == -1) {
            return new class_2382(-1, 0, 0);
        }
        if (direction.method_10263() == -1 && direction.method_10260() == 1) {
            return new class_2382(0, 0, 1);
        }
        if (direction.method_10263() == 1 && direction.method_10260() == -1) {
            return new class_2382(0, 0, -1);
        }
        if (direction.method_10263() == 1 && direction.method_10260() == 1) {
            return new class_2382(1, 0, 0);
        }
        throw new RuntimeException("Unknown how to get 45 left of offset: " + direction.method_23854());
    }

    private class_2382 get45RightDirection(class_2382 direction) {
        if (direction.method_10263() == -1 && direction.method_10260() == -1) {
            return new class_2382(0, 0, -1);
        }
        if (direction.method_10263() == -1 && direction.method_10260() == 1) {
            return new class_2382(-1, 0, 0);
        }
        if (direction.method_10263() == 1 && direction.method_10260() == -1) {
            return new class_2382(1, 0, 0);
        }
        if (direction.method_10263() == 1 && direction.method_10260() == 1) {
            return new class_2382(0, 0, 1);
        }
        throw new RuntimeException("Unknown how to get 45 right of offset: " + direction.method_23854());
    }

    private class_2382 getSidewaysOffset(class_2382 direction, int offset) {
        class_2382 leftDirection = this.getLeftDirection(direction);
        return leftDirection.method_35862(-offset);
    }

    private Optional<BlockPosAndState> getLiquidBlockAmOver(class_2338 pos) {
        int y = -1;
        while (!this.world.method_31601(pos.method_10264() + y)) {
            class_2680 bs = this.world.method_8320(pos.method_10069(0, y, 0));
            if (this.isFoundationBlock(bs)) {
                return Optional.empty();
            }
            if (!bs.method_26227().method_15769()) {
                return Optional.of(new BlockPosAndState(new class_2338(pos.method_10263(), pos.method_10264() + y, pos.method_10260()), bs));
            }
            --y;
        }
        return Optional.empty();
    }

    private Optional<BlockPosAndState> getFoundationBlockAmOver(class_2338 pos) {
        int y = -1;
        while (!this.world.method_31601(pos.method_10264() + y)) {
            class_2680 bs = this.world.method_8320(pos.method_10069(0, y, 0));
            if (this.isFoundationBlock(bs)) {
                return Optional.of(new BlockPosAndState(new class_2338(pos.method_10263(), pos.method_10264() + y, pos.method_10260()), bs));
            }
            --y;
        }
        return Optional.empty();
    }

    private Optional<BlockPosAndState> getFoundationOrLiquidBlockAmUnder(class_2338 pos) {
        int y = 1;
        while (!this.world.method_31601(pos.method_10264() + y)) {
            class_2680 bs = this.world.method_8320(pos.method_10069(0, y, 0));
            if (this.isFoundationBlock(bs) || !bs.method_26227().method_15769()) {
                return Optional.of(new BlockPosAndState(new class_2338(pos.method_10263(), pos.method_10264() + y, pos.method_10260()), bs));
            }
            ++y;
        }
        return Optional.empty();
    }

    private boolean isFoundationBlock(class_2680 blockState) {
        if (blockState.method_26215() || blockState.method_45474() || !blockState.method_26227().method_15769() || !blockState.method_26225()) {
            return false;
        }
        return !(blockState.method_26204() instanceof class_4863) && !(blockState.method_26204() instanceof class_2261) && !(blockState.method_26204() instanceof class_2397) && !blockState.method_26164(class_3481.field_15475) && !(blockState.method_26204() instanceof class_2346);
    }

    private Optional<class_2680> onlyIfDifferentBlock(class_2680 worldBlockState, class_2680 newBlockState, boolean returnDefaultState) {
        class_2680 blockStateToReturn;
        class_2680 class_26802 = blockStateToReturn = returnDefaultState ? newBlockState.method_26204().method_9564() : newBlockState;
        if (newBlockState.method_26215() && !worldBlockState.method_26215()) {
            return Optional.of(blockStateToReturn);
        }
        if (worldBlockState.method_26215() && newBlockState.method_26215()) {
            return Optional.empty();
        }
        if (Objects.equals(worldBlockState.method_26204().method_9539(), "block.minecraft.dirt") && Objects.equals(newBlockState.method_26204().method_9539(), "block.minecraft.grass_block")) {
            return Optional.empty();
        }
        if (Objects.equals(worldBlockState.method_26204().method_9539(), "block.minecraft.grass_block") && Objects.equals(newBlockState.method_26204().method_9539(), "block.minecraft.dirt")) {
            return Optional.empty();
        }
        if (!worldBlockState.method_26204().method_9539().equals(newBlockState.method_26204().method_9539())) {
            return Optional.of(blockStateToReturn);
        }
        return Optional.empty();
    }

    private Optional<class_2680> getBlockForPos(class_2338 pos, int sidewaysOffset, boolean andHalf, int verticalOffset, int forwardOffset, boolean diagonal, @Nullable BlockPosAndState foundationBlockAmOverCentral, @Nullable BlockPosAndState liquidBlockAmOverCentral, @Nullable BlockPosAndState blockAmUnderCentral, @Nullable BlockPosAndState blockAmUnderHigherCentral) {
        Optional<BlockPosAndState> foundationBlockAmOver = this.getFoundationBlockAmOver(pos);
        class_2680 blockState = this.world.method_8320(pos);
        if (Math.abs(sidewaysOffset) < this.getHalfWidth(diagonal) && verticalOffset == 0) {
            return this.onlyIfDifferentBlock(blockState, class_2246.field_10255.method_9564(), true);
        }
        if (Math.abs(sidewaysOffset) == (diagonal ? 1 : 2) && verticalOffset == 1) {
            return this.onlyIfDifferentBlock(blockState, class_2246.field_10167.method_9564(), false);
        }
        if (verticalOffset > 0 && verticalOffset < this.getTunnelHeight() && Math.abs(sidewaysOffset) < this.getHalfWidth(diagonal)) {
            return this.onlyIfDifferentBlock(blockState, class_2246.field_10124.method_9564(), true);
        }
        PathSegmentType pathSegmentType = blockAmUnderCentral != null ? (blockAmUnderHigherCentral != null ? PathSegmentType.TUNNEL : PathSegmentType.CUTTING) : (foundationBlockAmOverCentral != null && liquidBlockAmOverCentral == null ? (foundationBlockAmOver.isPresent() && Math.abs(foundationBlockAmOver.get().blockPos.method_10264() - pos.method_10264()) < this.getTunnelHeight() + 2 ? PathSegmentType.EMBANKMENT : PathSegmentType.BRIDGE) : (foundationBlockAmOverCentral != null ? PathSegmentType.BRIDGE : PathSegmentType.FLOATING_BRIDGE));
        if (Math.abs(sidewaysOffset) < this.getHalfWidth(diagonal) && verticalOffset == -1 && !this.isFoundationBlock(blockState)) {
            if (foundationBlockAmOver.isPresent() && (pathSegmentType == PathSegmentType.CUTTING || pathSegmentType == PathSegmentType.EMBANKMENT)) {
                return this.onlyIfDifferentBlock(blockState, foundationBlockAmOver.get().blockState, true);
            }
            return this.onlyIfDifferentBlock(blockState, class_2246.field_10056.method_9564(), true);
        }
        if (pathSegmentType == PathSegmentType.TUNNEL) {
            if (verticalOffset >= -1 && verticalOffset <= this.getTunnelHeight()) {
                if (Math.abs(sidewaysOffset) == this.getHalfWidth(diagonal)) {
                    if (verticalOffset == 3 && forwardOffset % 4 == 0) {
                        return this.onlyIfDifferentBlock(blockState, class_2246.field_10171.method_9564(), true);
                    }
                    return this.onlyIfDifferentBlock(blockState, class_2246.field_10056.method_9564(), true);
                }
                if (Math.abs(sidewaysOffset) <= this.getHalfWidth(diagonal)) {
                    if (verticalOffset == -1) {
                        if (!this.isFoundationBlock(blockState)) {
                            if (foundationBlockAmOver.isPresent()) {
                                return this.onlyIfDifferentBlock(blockState, foundationBlockAmOver.get().blockState, true);
                            }
                            return this.onlyIfDifferentBlock(blockState, class_2246.field_10056.method_9564(), true);
                        }
                        return Optional.empty();
                    }
                    if (verticalOffset == 0 || verticalOffset == this.getTunnelHeight()) {
                        return this.onlyIfDifferentBlock(blockState, class_2246.field_10056.method_9564(), true);
                    }
                    return this.onlyIfDifferentBlock(blockState, class_2246.field_10124.method_9564(), true);
                }
            }
            return Optional.empty();
        }
        if (pathSegmentType == PathSegmentType.CUTTING || pathSegmentType == PathSegmentType.EMBANKMENT) {
            if (verticalOffset <= 0) {
                if (foundationBlockAmOverCentral == null || foundationBlockAmOverCentral.blockState.method_26164(class_3481.field_15465) || foundationBlockAmOverCentral.blockState.method_26164(class_3481.field_15504)) {
                    return Math.abs(sidewaysOffset) <= this.getHalfWidth(diagonal) ? this.onlyIfDifferentBlock(blockState, class_2246.field_10056.method_9564(), true) : Optional.empty();
                }
                double value = -Math.pow((double)sidewaysOffset * 0.3, 2.0) + (double)this.getHalfWidth(diagonal) * 0.46;
                if (verticalOffset == -1 && Math.abs(sidewaysOffset) <= this.getHalfWidth(diagonal) || (double)verticalOffset < value) {
                    return this.onlyIfDifferentBlock(blockState, foundationBlockAmOverCentral.blockState.method_26204().method_9564(), true);
                }
            } else {
                double value = Math.pow((double)sidewaysOffset * 0.3, 2.0) - (double)this.getHalfWidth(diagonal) * 0.46;
                if ((double)verticalOffset > value) {
                    return this.onlyIfDifferentBlock(blockState, class_2246.field_10124.method_9564(), true);
                }
            }
            return Optional.empty();
        }
        if (verticalOffset == 1 && Math.abs(sidewaysOffset) == this.getHalfWidth(diagonal)) {
            return this.onlyIfDifferentBlock(blockState, class_2246.field_10252.method_9564(), true);
        }
        if (verticalOffset <= 0 && Math.abs(sidewaysOffset) <= this.getHalfWidth(diagonal)) {
            if (verticalOffset == 0 || verticalOffset == -1) {
                return this.onlyIfDifferentBlock(blockState, class_2246.field_10056.method_9564(), true);
            }
            if (pathSegmentType == PathSegmentType.BRIDGE && Math.abs(sidewaysOffset) == this.getHalfWidth(diagonal) - 1 && !andHalf && forwardOffset % 4 == 0) {
                return this.onlyIfDifferentBlock(blockState, class_2246.field_10056.method_9564(), true);
            }
        }
        return Optional.empty();
    }

    private Map<class_2338, class_2680> getBlocksForVertical(class_2338 pos, int sidewaysOffset, boolean andHalf, int forwardOffset, boolean diagonal, @Nullable BlockPosAndState foundationBlockAmOverCentral, @Nullable BlockPosAndState liquidBlockAmOverCentral, @Nullable BlockPosAndState blockAmUnderCentral, @Nullable BlockPosAndState blockAmUnderHigherCentral) {
        Optional<BlockPosAndState> foundationBlockAmOver = this.getFoundationBlockAmOver(pos);
        int startY = pos.method_10264();
        if (foundationBlockAmOver.isPresent()) {
            startY = foundationBlockAmOver.get().blockPos.method_10264();
        }
        if (Math.abs(startY - pos.method_10264()) < 2) {
            startY = pos.method_10264() - 2;
        }
        int endY = pos.method_10264() + 30;
        HashMap<class_2338, class_2680> toRet = new HashMap<class_2338, class_2680>();
        for (int y = startY; y <= endY; ++y) {
            int verticalOffset = y - pos.method_10264();
            this.getBlockForPos(pos, sidewaysOffset, andHalf, verticalOffset, forwardOffset, diagonal, foundationBlockAmOverCentral, liquidBlockAmOverCentral, blockAmUnderCentral, blockAmUnderHigherCentral).ifPresent(state -> toRet.put(pos.method_10069(0, verticalOffset, 0), (class_2680)state));
        }
        return toRet;
    }

    public Map<class_2338, class_2680> getBlocks() {
        HashMap<class_2338, class_2680> toRet = new HashMap<class_2338, class_2680>();
        class_2338 current = new class_2338((class_2382)this.pos1);
        class_2382 direction = new class_2382(0, 0, 0);
        int forwardOffset = 0;
        while (true) {
            Optional<class_2382> nextDirection;
            if ((nextDirection = this.getNextDirection(current)).isPresent()) {
                direction = nextDirection.get();
            }
            Optional<BlockPosAndState> foundationBlockAmOverCentral = this.getFoundationBlockAmOver(current);
            Optional<BlockPosAndState> liquidBlockAmOverCentral = this.getLiquidBlockAmOver(current);
            Optional<BlockPosAndState> blockAmUnderCentral = this.getFoundationOrLiquidBlockAmUnder(current);
            Optional<BlockPosAndState> blockAmUnderHigherCentral = this.getFoundationOrLiquidBlockAmUnder(current.method_10069(0, this.getTunnelHeight(), 0));
            boolean diagonal = direction.method_19455(new class_2382(0, direction.method_10264(), 0)) > 1;
            for (int i = -20; i <= 20; ++i) {
                class_2382 sidewaysOffset = this.getSidewaysOffset(direction, i);
                class_2338 blockPosWithSidewaysOffset = current.method_10081(sidewaysOffset);
                toRet.putAll(this.getBlocksForVertical(blockPosWithSidewaysOffset, i, false, forwardOffset, diagonal, foundationBlockAmOverCentral.orElse(null), liquidBlockAmOverCentral.orElse(null), blockAmUnderCentral.orElse(null), blockAmUnderHigherCentral.orElse(null)));
                if (!diagonal) continue;
                if (i <= 0) {
                    toRet.putAll(this.getBlocksForVertical(blockPosWithSidewaysOffset.method_10081(this.get45LeftDirection(direction)), i, true, forwardOffset, true, foundationBlockAmOverCentral.orElse(null), liquidBlockAmOverCentral.orElse(null), blockAmUnderCentral.orElse(null), blockAmUnderHigherCentral.orElse(null)));
                }
                if (i < 0) continue;
                toRet.putAll(this.getBlocksForVertical(blockPosWithSidewaysOffset.method_10081(this.get45RightDirection(direction)), i, true, forwardOffset, true, foundationBlockAmOverCentral.orElse(null), liquidBlockAmOverCentral.orElse(null), blockAmUnderCentral.orElse(null), blockAmUnderHigherCentral.orElse(null)));
            }
            if (nextDirection.isEmpty()) {
                return toRet;
            }
            current = current.method_10081(nextDirection.get());
            ++forwardOffset;
        }
    }

    public void TempPlaceBlocks() {
        Map<class_2338, class_2680> blocksSortedByYLevel = this.getBlocks();
        for (Map.Entry<class_2338, class_2680> entry : blocksSortedByYLevel.entrySet()) {
            this.world.method_8652(entry.getKey(), entry.getValue(), 3);
        }
    }

    private static enum PathSegmentType {
        TUNNEL,
        CUTTING,
        EMBANKMENT,
        BRIDGE,
        FLOATING_BRIDGE;

    }
}

