/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.ftech_robots.commandCenter;

import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.joml.Vector3f;
import uk.co.cablepost.ftech_robots.F_TechRobotsClient;
import uk.co.cablepost.ftech_robots.commandCenter.CommandCenterArmModel;
import uk.co.cablepost.ftech_robots.commandCenter.CommandCenterBlockEntity;
import uk.co.cablepost.ftech_robots.commandCenter.CommandCenterInit;
import uk.co.cablepost.ftech_robots.commandCenter.CommandCenterModel;
import uk.co.cablepost.ftech_robots.commandCenter.CommandCenterRackModel;
import uk.co.cablepost.ftech_robots.robot.RobotEntity;
import uk.co.cablepost.ftech_robots.robot.RobotEntityModel;

@Environment(value=EnvType.CLIENT)
public class CommandCenterBlockEntityRenderer
implements class_827<CommandCenterBlockEntity> {
    final CommandCenterModel commandCenterModel;
    final CommandCenterRackModel commandCenterRackModel;
    final CommandCenterArmModel commandCenterArmModel;
    final RobotEntityModel<RobotEntity> robotEntityModel;

    public CommandCenterBlockEntityRenderer(class_5614.class_5615 ctx) {
        this.commandCenterModel = new CommandCenterModel(ctx.method_32140(CommandCenterInit.MODEL_COMMAND_CENTER_LAYER));
        this.commandCenterRackModel = new CommandCenterRackModel(ctx.method_32140(CommandCenterInit.MODEL_COMMAND_CENTER_RACK_LAYER));
        this.commandCenterArmModel = new CommandCenterArmModel(ctx.method_32140(CommandCenterInit.MODEL_COMMAND_CENTER_ARM_LAYER));
        this.robotEntityModel = new RobotEntityModel(ctx.method_32140(F_TechRobotsClient.MODEL_ROBOT_LAYER));
    }

    public void render(CommandCenterBlockEntity blockEntity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        int light2 = class_761.method_23794((class_1920)((class_1920)Objects.requireNonNull(blockEntity.method_10997())), (class_2338)blockEntity.method_11016().method_10069(0, 3, 0));
        matrices.method_22903();
        matrices.method_46416(0.5f, 1.5f, 0.5f);
        matrices.method_22907(class_7833.field_40714.rotation((float)Math.PI));
        this.commandCenterModel.method_2828(matrices, vertexConsumers.getBuffer(class_1921.method_23576((class_2960)new class_2960("f_tech_robots", "textures/block/command_center.png"))), light2, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        matrices.method_22909();
        if (blockEntity.clientLastRobotCount == -1) {
            blockEntity.clientLastRobotCount = blockEntity.robots.size();
        } else if (blockEntity.clientLastRobotCount < blockEntity.robots.size()) {
            blockEntity.clientRobotArmAnimationCounter = 0.0f;
            blockEntity.clientRobotArmAnimationDirection = true;
            blockEntity.clientLastRobotCount = blockEntity.robots.size();
        } else if (blockEntity.clientLastRobotCount > blockEntity.robots.size()) {
            blockEntity.clientRobotArmAnimationCounter = 0.0f;
            blockEntity.clientRobotArmAnimationDirection = false;
            blockEntity.clientLastRobotCount = blockEntity.robots.size();
        }
        int robotsOutCount = blockEntity.robots.size();
        if (blockEntity.clientRobotArmAnimationCounter != -1.0f && !blockEntity.clientRobotArmAnimationDirection) {
            ++robotsOutCount;
        }
        matrices.method_46416(0.5f, 3.0f, 0.5f);
        matrices.method_22907(class_7833.field_40714.rotation((float)Math.PI));
        for (int l = 0; l < 3; ++l) {
            matrices.method_22903();
            matrices.method_46416(0.0f, 0.5f * (float)l, 0.0f);
            for (double r = 0.0; r < 10.0; r += 1.0) {
                matrices.method_22903();
                matrices.method_22907(class_7833.field_40716.rotation((float)(0.6283185307179586 * r)));
                matrices.method_46416(0.9f, 0.0f, 0.0f);
                matrices.method_22903();
                matrices.method_22907(class_7833.field_40716.rotation((float)Math.PI));
                matrices.method_22905(0.8f, 0.8f, 0.8f);
                matrices.method_46416(-0.35f, 0.78f, 0.0f);
                this.commandCenterRackModel.method_2828(matrices, vertexConsumers.getBuffer(class_1921.method_23576((class_2960)new class_2960("f_tech_robots", "textures/block/command_center_rack.png"))), light2, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                matrices.method_22909();
                if ((double)robotsOutCount <= (double)(l * 10) + r) {
                    this.robotEntityModel.method_2828(matrices, vertexConsumers.getBuffer(class_1921.method_23576((class_2960)new class_2960("f_tech_robots", "textures/entity/robot/robot.png"))), light2, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                }
                matrices.method_22909();
            }
            matrices.method_22909();
        }
        double armHeight = 0.0;
        double armDepth = 0.0;
        double armAngle = 0.0;
        if (blockEntity.clientRobotArmAnimationCounter > -1.0f) {
            blockEntity.clientRobotArmAnimationCounter += tickDelta;
            int animSpeedMul = 4;
            int indexOffset = blockEntity.clientRobotArmAnimationDirection ? 1 : 0;
            int slotShelf = 2 - (int)Math.floor((float)(blockEntity.robots.size() - indexOffset) / 10.0f);
            double slotHeight = (float)(2 - slotShelf) * 0.5f;
            double slotAngle = 0.6283185307179586 * (double)(blockEntity.robots.size() % 10 - indexOffset);
            double slotDepth = 0.9f;
            if (slotAngle > Math.PI) {
                slotAngle -= Math.PI * 2;
            }
            double topHeight = -1.96;
            double robotHeight = -1000.0;
            double robotDepth = -1000.0;
            double robotAngle = 0.0;
            if (blockEntity.clientRobotArmAnimationDirection) {
                if (blockEntity.clientRobotArmAnimationCounter < (float)(2 * animSpeedMul)) {
                    double progress = this.inverseLerp(0.0, 2 * animSpeedMul, blockEntity.clientRobotArmAnimationCounter);
                    robotHeight = slotHeight;
                    robotDepth = slotDepth;
                    robotAngle = slotAngle;
                    armHeight = this.lerp(0.0, slotShelf, progress);
                    armDepth = 0.0;
                    armAngle = this.lerp(0.0, slotAngle, progress);
                } else if (blockEntity.clientRobotArmAnimationCounter < (float)(3 * animSpeedMul)) {
                    double progress = this.inverseLerp(2 * animSpeedMul, 3 * animSpeedMul, blockEntity.clientRobotArmAnimationCounter);
                    robotHeight = slotHeight;
                    robotDepth = slotDepth;
                    robotAngle = slotAngle;
                    armHeight = slotShelf;
                    armDepth = this.lerp(0.0, slotDepth, progress);
                    armAngle = robotAngle;
                } else if (blockEntity.clientRobotArmAnimationCounter < (float)(4 * animSpeedMul)) {
                    double progress = this.inverseLerp(3 * animSpeedMul, 4 * animSpeedMul, blockEntity.clientRobotArmAnimationCounter);
                    robotHeight = slotHeight;
                    robotDepth = this.lerp(slotDepth, 0.0, progress);
                    robotAngle = slotAngle;
                    armHeight = slotShelf;
                    armDepth = this.lerp(slotDepth, 0.0, progress);
                    armAngle = robotAngle;
                } else if (blockEntity.clientRobotArmAnimationCounter < (float)(7 * animSpeedMul)) {
                    double progress = this.inverseLerp(4 * animSpeedMul, 7 * animSpeedMul, blockEntity.clientRobotArmAnimationCounter);
                    robotHeight = this.lerp(slotHeight, topHeight, progress);
                    robotDepth = 0.0;
                    robotAngle = this.lerp(slotAngle, 0.0, progress);
                    armHeight = slotShelf;
                    armDepth = 0.0;
                    armAngle = robotAngle;
                } else if (blockEntity.clientRobotArmAnimationCounter < (float)(10 * animSpeedMul)) {
                    double progress = this.inverseLerp(7 * animSpeedMul, 10 * animSpeedMul, blockEntity.clientRobotArmAnimationCounter);
                    robotHeight = topHeight;
                    robotDepth = 0.0;
                    robotAngle = 0.0;
                    armHeight = this.lerp(slotShelf, 0.0, progress);
                    armDepth = 0.0;
                    armAngle = 0.0;
                } else {
                    robotHeight = topHeight;
                    robotDepth = 0.0;
                    robotAngle = 0.0;
                    armHeight = 0.0;
                    armDepth = 0.0;
                    armAngle = 0.0;
                    blockEntity.clientRobotArmAnimationCounter = -1.0f;
                }
            } else if (blockEntity.clientRobotArmAnimationCounter < (float)(3 * animSpeedMul)) {
                double progress = this.inverseLerp(0.0, 3 * animSpeedMul, blockEntity.clientRobotArmAnimationCounter);
                robotHeight = topHeight;
                robotDepth = 0.0;
                robotAngle = 0.0;
                armHeight = this.lerp(0.0, slotShelf, progress);
                armDepth = 0.0;
                armAngle = 0.0;
            } else if (blockEntity.clientRobotArmAnimationCounter < (float)(6 * animSpeedMul)) {
                double progress = this.inverseLerp(3 * animSpeedMul, 6 * animSpeedMul, blockEntity.clientRobotArmAnimationCounter);
                robotHeight = this.lerp(topHeight, slotHeight, progress);
                robotDepth = 0.0;
                robotAngle = this.lerp(0.0, slotAngle, progress);
                armHeight = slotShelf;
                armDepth = 0.0;
                armAngle = robotAngle;
            } else if (blockEntity.clientRobotArmAnimationCounter < (float)(7 * animSpeedMul)) {
                double progress = this.inverseLerp(6 * animSpeedMul, 7 * animSpeedMul, blockEntity.clientRobotArmAnimationCounter);
                robotHeight = slotHeight;
                robotDepth = this.lerp(0.0, slotDepth, progress);
                robotAngle = slotAngle;
                armHeight = slotShelf;
                armDepth = robotDepth;
                armAngle = robotAngle;
            } else if (blockEntity.clientRobotArmAnimationCounter < (float)(8 * animSpeedMul)) {
                double progress = this.inverseLerp(7 * animSpeedMul, 8 * animSpeedMul, blockEntity.clientRobotArmAnimationCounter);
                robotHeight = slotHeight;
                robotDepth = slotDepth;
                robotAngle = slotAngle;
                armHeight = slotShelf;
                armDepth = this.lerp(slotDepth, 0.0, progress);
                armAngle = robotAngle;
            } else if (blockEntity.clientRobotArmAnimationCounter < (float)(10 * animSpeedMul)) {
                double progress = this.inverseLerp(8 * animSpeedMul, 10 * animSpeedMul, blockEntity.clientRobotArmAnimationCounter);
                robotHeight = slotHeight;
                robotDepth = slotDepth;
                robotAngle = slotAngle;
                armHeight = this.lerp(slotShelf, 0.0, progress);
                armDepth = 0.0;
                armAngle = this.lerp(robotAngle, 0.0, progress);
            } else {
                robotHeight = slotHeight;
                robotDepth = slotDepth;
                robotAngle = slotAngle;
                armHeight = 0.0;
                armDepth = 0.0;
                armAngle = 0.0;
                blockEntity.clientRobotArmAnimationCounter = -1.0f;
            }
            if (robotHeight > -1000.0) {
                matrices.method_22903();
                matrices.method_22904(0.0, robotHeight, 0.0);
                matrices.method_22907(class_7833.field_40716.rotation((float)robotAngle));
                matrices.method_22904(robotDepth, 0.0, 0.0);
                this.robotEntityModel.method_2828(matrices, vertexConsumers.getBuffer(class_1921.method_23576((class_2960)new class_2960("f_tech_robots", "textures/entity/robot/robot.png"))), light2, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                matrices.method_22909();
            }
        }
        matrices.method_22903();
        matrices.method_46416(0.0f, 1.3f, 0.0f);
        matrices.method_22907(class_7833.field_40716.rotation((float)armAngle + -1.5707964f));
        matrices.method_22905(0.8f, 1.1f, 0.8f);
        float v1min = 0.8f;
        float v1max = -5.0f;
        float v2min = 0.2f;
        float v2max = -6.0f;
        float h1min = 0.5f;
        float h1max = -4.5f;
        float h2min = 0.4f;
        float h2max = -4.5f;
        float h3min = 0.0f;
        float h3max = -4.5f;
        float v1 = (float)this.lerp(v1min, v1max, armHeight / 2.0);
        float v2 = (float)this.lerp(v2min, v2max, armHeight / 2.0);
        float h1 = (float)this.lerp(h1min, h1max, armDepth * (double)1.1f);
        float h2 = (float)this.lerp(h2min, h2max, armDepth * (double)1.1f);
        float h3 = (float)this.lerp(h3min, h3max, armDepth * (double)1.1f);
        this.commandCenterArmModel.v1.method_41920(new Vector3f(0.5f, v1, 0.0f));
        this.commandCenterArmModel.v2.method_41920(new Vector3f(0.0f, v2, 0.0f));
        this.commandCenterArmModel.h1.method_41920(new Vector3f(0.0f, 0.0f, h1));
        this.commandCenterArmModel.h2.method_41920(new Vector3f(0.0f, 0.0f, h2));
        this.commandCenterArmModel.h3.method_41920(new Vector3f(0.0f, 0.0f, h3));
        this.commandCenterArmModel.method_2828(matrices, vertexConsumers.getBuffer(class_1921.method_23576((class_2960)new class_2960("f_tech_robots", "textures/block/command_center_arm.png"))), light2, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        this.commandCenterArmModel.h1.method_41920(new Vector3f(0.0f, 0.0f, -h1));
        this.commandCenterArmModel.h2.method_41920(new Vector3f(0.0f, 0.0f, -h2));
        this.commandCenterArmModel.h3.method_41920(new Vector3f(0.0f, 0.0f, -h3));
        this.commandCenterArmModel.v2.method_41920(new Vector3f(0.0f, -v2, 0.0f));
        this.commandCenterArmModel.v1.method_41920(new Vector3f(-0.5f, -v1, 0.0f));
        matrices.method_22909();
    }

    double lerp(double a, double b, double f) {
        return a * (1.0 - f) + b * f;
    }

    double inverseLerp(double a, double b, double value) {
        if (a != b) {
            return (value - a) / (b - a);
        }
        return 0.0;
    }
}

