/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.ftech_robots.commandCenter;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import uk.co.cablepost.f_tech.config.FTechConfig;
import uk.co.cablepost.f_tech.machines.abstract_machine.AbstractMachineBlockEntity;
import uk.co.cablepost.ftech_robots.F_TechRobots;
import uk.co.cablepost.ftech_robots.StateSaverAndLoader;
import uk.co.cablepost.ftech_robots.buildInstructions.AbstractBuildInstructionsItem;
import uk.co.cablepost.ftech_robots.buildInstructions.BuildInstructions;
import uk.co.cablepost.ftech_robots.commandCenter.CommandCenterScreenHandler;
import uk.co.cablepost.ftech_robots.models.BlockPosAndState;
import uk.co.cablepost.ftech_robots.robot.RobotEntity;

public class CommandCenterBlockEntity
extends AbstractMachineBlockEntity {
    private int lastPlotItemHash = 0;
    @Nullable
    private BuildInstructions buildInstructions = null;
    List<UUID> robots = new ArrayList<UUID>();
    private int robotSpawnDelayCounter = 0;
    private int robotLastInOutCooldown = 0;
    private boolean needToStartChunkLoading = true;
    private int loadRobotsGracePeriod = 1000;
    public float clientRobotArmAnimationCounter = -1.0f;
    public int clientLastRobotCount = -1;
    public boolean clientRobotArmAnimationDirection = false;

    public CommandCenterBlockEntity(class_2338 pos, class_2680 state) {
        super(F_TechRobots.COMMAND_CENTER.getBlockEntity(), pos, state, new int[]{0}, new int[]{1}, 1000000, 1000, 0, false);
    }

    public int getMaxProcessProgress() {
        return this.buildInstructions == null ? 0 : (this.buildInstructions.getStartingSize() == null ? 0 : this.buildInstructions.getStartingSize());
    }

    private void writeNbt(class_2487 tag, boolean saveToFile) {
        if (this.buildInstructions != null) {
            this.buildInstructions.writeInstructionsNbt(this.field_11863, saveToFile);
        }
        super.method_11007(tag);
        int c = 0;
        for (UUID robot : this.robots) {
            tag.method_25927("Robot_" + c, robot);
            ++c;
        }
    }

    public void method_11007(class_2487 tag) {
        this.writeNbt(tag, true);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.robots = new ArrayList<UUID>();
        for (String key : tag.method_10541()) {
            if (!key.startsWith("Robot_")) continue;
            this.robots.add(tag.method_25926(key));
        }
    }

    public class_2487 method_16887() {
        class_2487 nbtCompound = new class_2487();
        this.writeNbt(nbtCompound, false);
        return nbtCompound;
    }

    public int processEnergyConsumption() {
        return 100 * FTechConfig.CONFIG.getOrDefault("f_tech_core.energy_mul", 1);
    }

    public boolean haveEnoughEnergy() {
        return this._energyAmount >= (long)this.processEnergyConsumption();
    }

    public void serverTickExtra() {
        if (this.needToStartChunkLoading) {
            assert (this.field_11863 != null);
            ((class_3218)this.field_11863).method_14178().method_17297(F_TechRobots.COMMAND_CENTER_TICKET_TYPE, new class_1923(this.field_11867), 3, (Object)this.field_11867);
            StateSaverAndLoader fTechRobotsState = (StateSaverAndLoader)((class_3218)this.field_11863).method_17983().method_17924(StateSaverAndLoader::createFromNbt, StateSaverAndLoader::new, "f_tech_robots");
            if (fTechRobotsState.controllerBlockPoses.stream().noneMatch(x -> x.method_19455((class_2382)this.field_11867) == 0)) {
                fTechRobotsState.controllerBlockPoses.add(this.field_11867);
                fTechRobotsState.method_80();
            }
            this.needToStartChunkLoading = false;
        }
        int currentPlotItemHash = 0;
        if (!((class_1799)this._inventory.get(0)).method_7960()) {
            currentPlotItemHash = ((class_1799)this._inventory.get(0)).hashCode();
        }
        if (this.lastPlotItemHash != currentPlotItemHash) {
            this.buildInstructions = null;
            if (currentPlotItemHash != 0 && ((class_1799)this._inventory.get(0)).method_7909() instanceof AbstractBuildInstructionsItem) {
                this.buildInstructions = new BuildInstructions((class_1799)this._inventory.get(0), this.field_11863);
            }
            this.lastPlotItemHash = currentPlotItemHash;
        }
        long processEnergyConsumption = this.processEnergyConsumption();
        if (this.buildInstructions != null && this._energyAmount > 0L) {
            this._energyAmount = Math.max(0L, this._energyAmount - processEnergyConsumption);
            this.method_5431();
        }
        class_2338 homePos = this.field_11867.method_10069(0, 3, 0);
        assert (this.field_11863 != null);
        ++this.robotSpawnDelayCounter;
        if (this.robotLastInOutCooldown < 1000) {
            ++this.robotLastInOutCooldown;
        }
        if (this.robotSpawnDelayCounter >= 30) {
            this.robotSpawnDelayCounter = 0;
            if (this.robots.size() < 30 && this.buildInstructions != null && this.robotLastInOutCooldown > 50 && this._energyAmount >= processEnergyConsumption) {
                Integer blocksToChangeSize = this.buildInstructions.getBlocksToChangeSize();
                if (blocksToChangeSize != null) {
                    int lastProcessProgress = this._processProgress;
                    this._processProgress = this.getMaxProcessProgress() - blocksToChangeSize;
                    if (lastProcessProgress != this._processProgress) {
                        this.method_5431();
                    }
                } else {
                    if (this._processProgress > 0) {
                        this.method_5431();
                    }
                    this._processProgress = 0;
                }
                BlockPosAndState toDoNext = this.buildInstructions.getNextBlockToChange(this.field_11863, null);
                if (toDoNext != null) {
                    RobotEntity robotEntity = (RobotEntity)F_TechRobots.ROBOT_ENTITY.method_5883(this.field_11863);
                    assert (robotEntity != null);
                    robotEntity.method_5808(homePos.method_46558().method_10216(), homePos.method_46558().method_10214(), homePos.method_46558().method_10215(), 0.0f, 0.0f);
                    robotEntity.setHomeLocation(homePos);
                    robotEntity.tryGetObjectives(this);
                    this.field_11863.method_8649((class_1297)robotEntity);
                    this.robots.add(robotEntity.method_5667());
                    this.robotLastInOutCooldown = 0;
                    this.method_5431();
                    this.field_11863.method_8413(this.field_11867, this.field_11863.method_8320(this.field_11867), this.field_11863.method_8320(this.field_11867), 2);
                } else if (this.method_5438(1).method_7960()) {
                    this.method_5447(1, new class_1799((class_1935)this.method_5438(0).method_7909()));
                    this.method_5441(0);
                    this.buildInstructions.wipeInstructionsAndInstructionsNbt(this.field_11863, true);
                    this.buildInstructions = null;
                    this.lastPlotItemHash = 0;
                    this.method_5431();
                }
            }
            if (this.buildInstructions == null) {
                this._processProgress = 0;
            } else if (!this.robots.isEmpty() && this.robots.stream().anyMatch(x -> {
                RobotEntity robot = (RobotEntity)((class_3218)this.field_11863).method_14190(x);
                if (robot == null) {
                    return false;
                }
                return robot.method_24515().method_10263() == homePos.method_10263() && robot.method_24515().method_10264() == homePos.method_10264() && robot.method_24515().method_10260() == homePos.method_10260();
            })) {
                this.buildInstructions.removeCompletedInstructions(this.field_11863);
            }
        }
        if (this.robotLastInOutCooldown > 50) {
            for (int i = this.robots.size() - 1; i >= 0; --i) {
                Integer blocksToChangeSize;
                RobotEntity robot = (RobotEntity)((class_3218)this.field_11863).method_14190(this.robots.get(i));
                if (robot == null) continue;
                Integer n = blocksToChangeSize = this.buildInstructions == null ? Integer.valueOf(0) : this.buildInstructions.getBlocksToChangeSize();
                if (blocksToChangeSize != null && blocksToChangeSize != 0 || robot.hasObjective() || robot.method_24515().method_10263() != homePos.method_10263() || robot.method_24515().method_10264() != homePos.method_10264() || robot.method_24515().method_10260() != homePos.method_10260()) continue;
                this.robots.remove(robot.method_5667());
                this.robotLastInOutCooldown = 0;
                robot.method_20620(homePos.method_46558().field_1352, homePos.method_46558().field_1351, homePos.method_46558().field_1350);
                for (int j = 0; j < 5; ++j) {
                    ((class_3218)this.field_11863).method_14199((class_2394)class_2398.field_11204, (double)((float)homePos.method_10263() - 0.5f) + this.field_11863.field_9229.method_43058() * 2.0, (double)homePos.method_10264() + this.field_11863.field_9229.method_43058() * (double)1.6f, (double)((float)homePos.method_10260() - 0.5f) + this.field_11863.field_9229.method_43058() * 2.0, 5, 0.0, 0.0, 0.0, 0.0);
                }
                robot.method_5650(class_1297.class_5529.field_26998);
                this.method_5431();
                this.field_11863.method_8413(this.field_11867, this.field_11863.method_8320(this.field_11867), this.field_11863.method_8320(this.field_11867), 2);
                break;
            }
        }
        if (this.loadRobotsGracePeriod > 0) {
            --this.loadRobotsGracePeriod;
        } else {
            boolean removedA = this.robots.removeIf(robotUuid -> {
                RobotEntity robot = (RobotEntity)((class_3218)this.field_11863).method_14190(robotUuid);
                return robot == null || !robot.method_5805();
            });
            boolean removedB = this.robots.removeIf(Objects::isNull);
            if (removedA || removedB) {
                this.method_5431();
                this.field_11863.method_8413(this.field_11867, this.field_11863.method_8320(this.field_11867), this.field_11863.method_8320(this.field_11867), 2);
            }
        }
    }

    public void killRobots() {
        assert (this.field_11863 != null);
        for (int i = this.robots.size() - 1; i >= 0; --i) {
            RobotEntity robot = (RobotEntity)((class_3218)this.field_11863).method_14190(this.robots.get(i));
            if (robot == null) continue;
            this.robots.remove((Object)robot);
            robot.method_5650(class_1297.class_5529.field_26998);
            this.field_11863.method_8413(this.field_11867, this.field_11863.method_8320(this.field_11867), this.field_11863.method_8320(this.field_11867), 2);
        }
    }

    public boolean containsRobot(UUID uuid) {
        return this.robots.contains(uuid);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new CommandCenterScreenHandler(syncId, playerInventory, (class_2586)this, this._propertyDelegate);
    }

    @Nullable
    public BlockPosAndState getNextBlockToChange(@Nullable class_1792 ofItem) {
        if (this.buildInstructions == null) {
            return null;
        }
        return this.buildInstructions.getNextBlockToChange(this.field_11863, ofItem);
    }

    public void removeBlockToChange(class_2338 objectiveLocation, class_2680 blockState) {
        if (this.buildInstructions == null) {
            return;
        }
        this.buildInstructions.removeBlockToChange(objectiveLocation, blockState);
        Integer blocksToChangeSize = this.buildInstructions.getBlocksToChangeSize();
        if (blocksToChangeSize != null) {
            this._processProgress = this.getMaxProcessProgress() - blocksToChangeSize;
        }
        this.method_5431();
    }

    public void sayPowerStatus(class_1657 player) {
        if (!this.haveEnoughEnergy()) {
            player.method_43496((class_2561)class_2561.method_43470((String)"Out of power, robots are unable to continue construction until more energy is supplied.").method_27692(class_124.field_1061).method_27692(class_124.field_1067));
        }
    }

    public void listRobotStatuses(class_1657 player) {
        for (UUID robotUuid : this.robots) {
            assert (this.field_11863 != null);
            RobotEntity robot = (RobotEntity)((class_3218)this.field_11863).method_14190(robotUuid);
            if (robot == null) continue;
            player.method_43496(robot.getStatusText());
        }
    }
}

