/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.ftech_robots.buildInstructions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2328;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import org.jetbrains.annotations.Nullable;
import uk.co.cablepost.ftech_robots.buildInstructions.BuildInstructionsFileUtils;
import uk.co.cablepost.ftech_robots.models.BlockPosAndState;

public class BuildInstructions {
    private final class_1799 _itemStack;
    @Nullable
    private UUID _instructionsUuid = null;
    @Nullable
    private List<BlockPosAndState> _instructions = null;
    @Nullable
    private Integer _startingSize = null;
    public static final Codec<BlockPosAndState> BLOCK_POS_AND_STATE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2338.field_25064.fieldOf("pos").forGetter(BlockPosAndState::getBlockPos), (App)class_2680.field_24734.fieldOf("state").forGetter(BlockPosAndState::getBlockState)).apply((Applicative)instance, BlockPosAndState::new));

    public BuildInstructions(class_1799 itemStack, class_1937 world) {
        this._itemStack = itemStack;
        this.readInstructionsNbt(world);
    }

    private void readInstructionsNbt(class_1937 world) {
        class_2487 nbtCompound = this._itemStack.method_7948();
        if (!nbtCompound.method_10545("instructions_uuid")) {
            this._instructions = null;
            return;
        }
        this._instructionsUuid = nbtCompound.method_25926("instructions_uuid");
        this._startingSize = nbtCompound.method_10550("instructions_starting_size");
        @Nullable class_2520 loadedInstructions = null;
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            loadedInstructions = BuildInstructionsFileUtils.load(serverWorld, nbtCompound.method_25926("instructions_uuid").toString());
        }
        if (loadedInstructions == null) {
            this._instructions = null;
            return;
        }
        Codec listCodec = BLOCK_POS_AND_STATE_CODEC.listOf();
        Optional instructions = listCodec.parse((DynamicOps)class_2509.field_11560, loadedInstructions).result();
        if (instructions.isEmpty()) {
            throw new RuntimeException("Failed to read instructions from NBT");
        }
        this._instructions = new ArrayList<BlockPosAndState>((Collection)instructions.get());
    }

    public void writeInstructionsNbt(class_1937 world, boolean saveToFile) {
        if (this._instructions == null) {
            this.wipeInstructionsAndInstructionsNbt(world, saveToFile);
            return;
        }
        assert (this._startingSize != null);
        assert (this._instructionsUuid != null);
        class_2487 nbtCompound = this._itemStack.method_7948();
        Codec listCodec = BLOCK_POS_AND_STATE_CODEC.listOf();
        Optional instructionsNbt = listCodec.encodeStart((DynamicOps)class_2509.field_11560, this._instructions).result();
        if (instructionsNbt.isEmpty()) {
            throw new RuntimeException("Failed to write instructions to NBT");
        }
        if (saveToFile && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            BuildInstructionsFileUtils.save(serverWorld, this._instructionsUuid.toString(), (class_2520)instructionsNbt.get());
        }
        nbtCompound.method_10569("instructions_starting_size", this._startingSize.intValue());
        nbtCompound.method_10569("instructions_hash", ((class_2520)instructionsNbt.get()).hashCode());
        nbtCompound.method_25927("instructions_uuid", this._instructionsUuid);
    }

    public void removeCompletedInstructions(class_1937 world) {
        if (this._instructions == null) {
            return;
        }
        this._instructions.removeIf(x -> {
            if (!world.method_24794(x.blockPos)) {
                return true;
            }
            class_2680 worldBlockState = world.method_8320(x.blockPos);
            if (worldBlockState.method_26204() instanceof class_2328) {
                return true;
            }
            if (!worldBlockState.method_26215() && worldBlockState.method_26204().method_36555() == -1.0f) {
                return true;
            }
            return x.blockState.method_26215() && worldBlockState.method_26215() || x.blockState.method_26215() && worldBlockState.method_45474() || Objects.equals(x.blockState.method_26204().method_9539(), worldBlockState.method_26204().method_9539()) || Objects.equals(worldBlockState.method_26204().method_9539(), "block.minecraft.dirt") && Objects.equals(x.blockState.method_26204().method_9539(), "block.minecraft.grass_block") || Objects.equals(worldBlockState.method_26204().method_9539(), "block.minecraft.grass_block") && Objects.equals(x.blockState.method_26204().method_9539(), "block.minecraft.dirt");
        });
    }

    private Optional<BlockPosAndState> findFirstInInstructions(Predicate<BlockPosAndState> predicate) {
        if (this._instructions == null) {
            return Optional.empty();
        }
        for (BlockPosAndState blockPosAndState : this._instructions) {
            if (!predicate.test(blockPosAndState)) continue;
            return Optional.of(blockPosAndState);
        }
        return Optional.empty();
    }

    @Nullable
    public BlockPosAndState getNextBlockToChange(class_1937 world, @Nullable class_1792 ofItem) {
        Optional<BlockPosAndState> blockThatNeedsPlacingNextToOtherBlock;
        Optional<BlockPosAndState> blockThatNeedsBreaking;
        if (this._instructions == null) {
            return null;
        }
        if ((ofItem == null || ofItem == class_1802.field_8162) && (blockThatNeedsBreaking = this.findFirstInInstructions(x -> !world.method_8320(x.blockPos).method_26215() && !world.method_8320(x.blockPos).method_45474() && x.blockState.method_26215())).isPresent()) {
            return new BlockPosAndState(blockThatNeedsBreaking.get().blockPos, class_2246.field_10124.method_9564());
        }
        if ((ofItem == null || ofItem != class_1802.field_8162) && (blockThatNeedsPlacingNextToOtherBlock = this.findFirstInInstructions(x -> !(ofItem != null && !x.blockState.method_26204().method_8389().equals(ofItem) || (!(x.blockState.method_26204() instanceof class_2346) || world.method_8320(x.blockPos.method_10074()).method_45474()) && x.blockState.method_26204() instanceof class_2346 || !x.blockState.method_26204().method_9558(x.blockState.method_26204().method_9564(), (class_4538)world, x.blockPos) || Objects.equals(x.blockState.method_26204().method_9539(), world.method_8320(x.blockPos).method_26204().method_9539()) || !world.method_8320(x.blockPos.method_10084()).method_51367() && !world.method_8320(x.blockPos.method_10074()).method_51367() && !world.method_8320(x.blockPos.method_10095()).method_51367() && !world.method_8320(x.blockPos.method_10078()).method_51367() && !world.method_8320(x.blockPos.method_10072()).method_51367() && !world.method_8320(x.blockPos.method_10067()).method_51367()))).isPresent()) {
            return blockThatNeedsPlacingNextToOtherBlock.map(blockPosAndState -> new BlockPosAndState(blockPosAndState.blockPos, blockPosAndState.blockState)).orElse(null);
        }
        if (ofItem == null || ofItem != class_1802.field_8162) {
            Optional<BlockPosAndState> blockThatNeedsPlacing = this.findFirstInInstructions(x -> (ofItem == null || x.blockState.method_26204().method_8389().equals(ofItem)) && (x.blockState.method_26204() instanceof class_2346 && !world.method_8320(x.blockPos.method_10074()).method_45474() || !(x.blockState.method_26204() instanceof class_2346)) && x.blockState.method_26204().method_9558(x.blockState.method_26204().method_9564(), (class_4538)world, x.blockPos) && !Objects.equals(x.blockState.method_26204().method_9539(), world.method_8320(x.blockPos).method_26204().method_9539()));
            return blockThatNeedsPlacing.map(blockPosAndState -> new BlockPosAndState(blockPosAndState.blockPos, blockPosAndState.blockState)).orElse(null);
        }
        return null;
    }

    @Nullable
    public List<BlockPosAndState> getInstructions() {
        if (this._instructions == null) {
            return null;
        }
        return this._instructions;
    }

    @Nullable
    public Integer getBlocksToChangeSize() {
        if (this._instructions == null) {
            return null;
        }
        return this._instructions.size();
    }

    @Nullable
    public Integer getStartingSize() {
        return this._startingSize;
    }

    public void removeBlockToChange(class_2338 blockPos, class_2680 blockState) {
        if (this._instructions == null) {
            return;
        }
        this._instructions.removeIf(x -> x.blockPos.method_19455((class_2382)blockPos) == 0 && x.blockState.hashCode() == blockState.hashCode());
        if (this._instructions.isEmpty()) {
            this._instructions = null;
        }
    }

    public void setInstructionsAndWrite(ArrayList<BlockPosAndState> instructions, class_1937 world, class_2338 startingPos) {
        if (this._instructions != null) {
            this.wipeInstructionsAndInstructionsNbt(world, true);
        }
        assert (instructions != null);
        this._instructionsUuid = UUID.randomUUID();
        this._instructions = instructions;
        this.addBreakInstructionsToStart(world);
        this.sortInstructions(startingPos);
        this.removeCompletedInstructions(world);
        this._startingSize = this._instructions.size();
        this.writeInstructionsNbt(world, true);
    }

    private void addBreakInstructionsToStart(class_1937 world) {
        if (this._instructions == null) {
            return;
        }
        for (BlockPosAndState instruction : new ArrayList<BlockPosAndState>(this._instructions)) {
            class_2680 worldBlockState = world.method_8320(instruction.blockPos);
            if (worldBlockState.method_26215() || worldBlockState.method_45474() || Objects.equals(instruction.blockState.method_26204().method_9539(), worldBlockState.method_26204().method_9539()) || Objects.equals(worldBlockState.method_26204().method_9539(), "block.minecraft.dirt") && Objects.equals(instruction.blockState.method_26204().method_9539(), "block.minecraft.grass_block") || Objects.equals(instruction.blockState.method_26204().method_9539(), "block.minecraft.dirt") && Objects.equals(worldBlockState.method_26204().method_9539(), "block.minecraft.grass_block")) continue;
            this._instructions.add(0, new BlockPosAndState(instruction.blockPos, class_2246.field_10124.method_9564()));
        }
    }

    private void sortInstructions(class_2338 startingPos) {
        assert (this._instructions != null);
        this._instructions.sort((a, b) -> {
            if (a.blockState.method_26215() == b.blockState.method_26215() && a.blockPos.method_10264() == b.blockPos.method_10264()) {
                if (a.blockState.method_26215() && b.blockState.method_26215()) {
                    int bDis;
                    int aDis = startingPos.method_19455((class_2382)a.blockPos);
                    if (aDis < (bDis = startingPos.method_19455((class_2382)b.blockPos))) {
                        return -1;
                    }
                    if (bDis < aDis) {
                        return 1;
                    }
                }
                return 0;
            }
            if (a.blockState.method_26215() && !b.blockState.method_26215()) {
                return -1;
            }
            if (!a.blockState.method_26215() && b.blockState.method_26215()) {
                return 1;
            }
            if (a.blockState.method_26215() && b.blockState.method_26215()) {
                if (a.blockPos.method_10264() > b.blockPos.method_10264()) {
                    return -1;
                }
                return 1;
            }
            if (a.blockPos.method_10264() > b.blockPos.method_10264()) {
                return 1;
            }
            return -1;
        });
    }

    public void wipeInstructionsAndInstructionsNbt(class_1937 world, boolean saveToFile) {
        this._instructions = null;
        class_2487 nbtCompound = this._itemStack.method_7948();
        if (saveToFile && nbtCompound.method_10545("instructions_uuid") && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            BuildInstructionsFileUtils.delete(serverWorld, nbtCompound.method_25926("instructions_uuid").toString());
        }
        nbtCompound.method_10551("instructions_starting_size");
        nbtCompound.method_10551("instructions_hash");
    }
}

