/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.util;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.recipe.v1.ingredient.DefaultCustomIngredients;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7923;

@Deprecated
public class CraftingHelper {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static class_1856 getIngredient(JsonElement json) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Json cannot be null");
        }
        if (json.isJsonArray()) {
            ArrayList ingredients = Lists.newArrayList();
            ArrayList vanilla = Lists.newArrayList();
            json.getAsJsonArray().forEach(ele -> {
                class_1856 ing = CraftingHelper.getIngredient(ele);
                if (ing.getClass() == class_1856.class) {
                    vanilla.add(ing);
                } else {
                    ingredients.add(ing);
                }
            });
            if (!vanilla.isEmpty()) {
                ingredients.add(class_1856.method_8092(vanilla.stream().flatMap(i -> Arrays.stream(i.field_9019))));
            }
            if (ingredients.size() == 0) {
                throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
            }
            if (ingredients.size() == 1) {
                return (class_1856)ingredients.get(0);
            }
            return DefaultCustomIngredients.any((class_1856[])((class_1856[])ingredients.toArray(class_1856[]::new)));
        }
        if (!json.isJsonObject()) {
            throw new JsonSyntaxException("Expcted ingredient to be a object or array of objects");
        }
        return class_1856.method_52177((JsonElement)json);
    }

    public static class_1799 getItemStack(JsonObject json, boolean readNBT) {
        return CraftingHelper.getItemStack(json, readNBT, false);
    }

    public static class_1792 getItem(String itemName, boolean disallowsAirInRecipe) {
        class_1792 item = CraftingHelper.tryGetItem(itemName, disallowsAirInRecipe);
        if (item == null) {
            if (!class_7923.field_41178.method_10250(new class_2960(itemName))) {
                throw new JsonSyntaxException("Unknown item '" + itemName + "'");
            }
            if (disallowsAirInRecipe && item == class_1802.field_8162) {
                throw new JsonSyntaxException("Invalid item: " + itemName);
            }
        }
        return Objects.requireNonNull(item);
    }

    @Nullable
    public static class_1792 tryGetItem(String itemName, boolean disallowsAirInRecipe) {
        class_2960 itemKey = new class_2960(itemName);
        if (!class_7923.field_41178.method_10250(itemKey)) {
            return null;
        }
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemKey);
        if (disallowsAirInRecipe && item == class_1802.field_8162) {
            return null;
        }
        return item;
    }

    public static class_2487 getNBT(JsonElement element) {
        try {
            if (element.isJsonObject()) {
                return class_2522.method_10718((String)GSON.toJson(element));
            }
            return class_2522.method_10718((String)class_3518.method_15287((JsonElement)element, (String)"nbt"));
        }
        catch (CommandSyntaxException e) {
            throw new JsonSyntaxException("Invalid NBT Entry: " + String.valueOf((Object)e));
        }
    }

    @Nullable
    public static class_2487 tryGetNBT(JsonElement element) {
        try {
            if (element.isJsonObject()) {
                return class_2522.method_10718((String)GSON.toJson(element));
            }
            return class_2522.method_10718((String)class_3518.method_15287((JsonElement)element, (String)"nbt"));
        }
        catch (CommandSyntaxException e) {
            return null;
        }
    }

    public static class_1799 getItemStack(JsonObject json, boolean readNBT, boolean disallowsAirInRecipe) {
        String itemName = class_3518.method_15265((JsonObject)json, (String)"item");
        class_1792 item = CraftingHelper.getItem(itemName, disallowsAirInRecipe);
        if (readNBT && json.has("nbt")) {
            class_2487 nbt = CraftingHelper.getNBT(json.get("nbt"));
            class_2487 tmp = new class_2487();
            if (nbt.method_10545("ForgeCaps")) {
                tmp.method_10566("ForgeCaps", nbt.method_10580("ForgeCaps"));
                nbt.method_10551("ForgeCaps");
            }
            tmp.method_10566("tag", (class_2520)nbt);
            tmp.method_10582("id", itemName);
            tmp.method_10569("Count", class_3518.method_15282((JsonObject)json, (String)"count", (int)1));
            return class_1799.method_7915((class_2487)tmp);
        }
        return new class_1799((class_1935)item, class_3518.method_15282((JsonObject)json, (String)"count", (int)1));
    }

    @Nullable
    public static class_1799 tryGetItemStack(JsonObject json, boolean readNBT, boolean disallowsAirInRecipe) {
        JsonElement nameElement = json.get("name");
        if (nameElement == null || !nameElement.isJsonPrimitive()) {
            return null;
        }
        String itemName = nameElement.getAsString();
        class_1792 item = CraftingHelper.tryGetItem(itemName, disallowsAirInRecipe);
        if (readNBT && json.has("nbt")) {
            class_2487 nbt = CraftingHelper.tryGetNBT(json.get("nbt"));
            if (nbt == null) {
                return null;
            }
            class_2487 tmp = new class_2487();
            if (nbt.method_10545("ForgeCaps")) {
                tmp.method_10566("ForgeCaps", nbt.method_10580("ForgeCaps"));
                nbt.method_10551("ForgeCaps");
            }
            tmp.method_10566("tag", (class_2520)nbt);
            tmp.method_10582("id", itemName);
            tmp.method_10569("Count", class_3518.method_15282((JsonObject)json, (String)"count", (int)1));
            return class_1799.method_7915((class_2487)tmp);
        }
        return new class_1799((class_1935)item, class_3518.method_15282((JsonObject)json, (String)"count", (int)1));
    }

    public static class_1856 merge(Collection<class_1856> parts) {
        return class_1856.method_8092(parts.stream().flatMap(i -> Arrays.stream(i.field_9019)));
    }

    public static boolean areShareTagsEqual(class_1799 stack, class_1799 other) {
        class_2487 shareTagA = stack.method_7969();
        class_2487 shareTagB = other.method_7969();
        if (shareTagA == null) {
            return shareTagB == null;
        }
        return shareTagB != null && shareTagA.equals((Object)shareTagB);
    }

    public static Predicate<JsonObject> getConditionPredicate(JsonObject json) {
        return ResourceConditions.get((class_2960)new class_2960(class_3518.method_15265((JsonObject)json, (String)"condition")));
    }

    public static boolean processConditions(JsonArray conditions) {
        for (int x = 0; x < conditions.size(); ++x) {
            if (!conditions.get(x).isJsonObject()) {
                throw new JsonSyntaxException("Conditions must be an array of JsonObjects");
            }
            JsonObject json = conditions.get(x).getAsJsonObject();
            if (CraftingHelper.getConditionPredicate(json).test(json)) continue;
            return false;
        }
        return true;
    }

    public static boolean processConditions(JsonObject json, String memberName) {
        return !json.has(memberName) || CraftingHelper.processConditions(class_3518.method_15261((JsonObject)json, (String)memberName));
    }
}

