/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.util.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_1799;
import net.minecraft.class_2477;
import net.minecraft.class_2583;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public class ScreenUtils {
    public static final int DEFAULT_BACKGROUND_COLOR = -267386864;
    public static final int DEFAULT_BORDER_COLOR_START = 0x505000FF;
    public static final int DEFAULT_BORDER_COLOR_END = 1344798847;

    public static void drawGradientRect(Matrix4f matrix, int z, int left, int top, int right, int bottom, int startColor, int endColor) {
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        buffer.method_22918(matrix, (float)right, (float)top, (float)z).method_22915(startRed, startGreen, startBlue, startAlpha).method_1344();
        buffer.method_22918(matrix, (float)left, (float)top, (float)z).method_22915(startRed, startGreen, startBlue, startAlpha).method_1344();
        buffer.method_22918(matrix, (float)left, (float)bottom, (float)z).method_22915(endRed, endGreen, endBlue, endAlpha).method_1344();
        buffer.method_22918(matrix, (float)right, (float)bottom, (float)z).method_22915(endRed, endGreen, endBlue, endAlpha).method_1344();
        tessellator.method_1350();
        RenderSystem.disableBlend();
    }

    public static void drawHoveringText(class_4587 mStack, List<? extends class_5348> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, int backgroundColor, int borderColorStart, int borderColorEnd, class_327 font) {
        ScreenUtils.drawHoveringText(class_1799.field_8037, mStack, textLines, mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, backgroundColor, borderColorStart, borderColorEnd, font);
    }

    public static void drawHoveringText(@Nonnull class_1799 stack, class_4587 mStack, List<? extends class_5348> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, int backgroundColor, int borderColorStart, int borderColorEnd, class_327 font) {
        if (!textLines.isEmpty()) {
            int n;
            RenderSystem.disableDepthTest();
            int tooltipTextWidth = 0;
            for (class_5348 class_53482 : textLines) {
                int textLineWidth = font.method_27525(class_53482);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            boolean bl = true;
            int tooltipX = mouseX + 12;
            if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
                needsWrap = true;
            }
            if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList<? extends class_5348> wrappedTextLines = new ArrayList<class_5348>();
                for (int i = 0; i < textLines.size(); ++i) {
                    class_5348 textLine = textLines.get(i);
                    List wrappedLine = font.method_27527().method_27495(textLine, tooltipTextWidth, class_2583.field_24360);
                    if (i == 0) {
                        n = wrappedLine.size();
                    }
                    for (class_5348 line : wrappedLine) {
                        int lineWidth = font.method_27525(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add((class_5348)line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
            }
            int tooltipY = mouseY - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > n) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY < 4) {
                tooltipY = 4;
            } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 4;
            }
            int zLevel = 400;
            mStack.method_22903();
            Matrix4f mat = mStack.method_23760().method_23761();
            ScreenUtils.drawGradientRect(mat, 400, tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, backgroundColor, backgroundColor);
            ScreenUtils.drawGradientRect(mat, 400, tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, backgroundColor, backgroundColor);
            ScreenUtils.drawGradientRect(mat, 400, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
            ScreenUtils.drawGradientRect(mat, 400, tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
            ScreenUtils.drawGradientRect(mat, 400, tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
            ScreenUtils.drawGradientRect(mat, 400, tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
            ScreenUtils.drawGradientRect(mat, 400, tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
            ScreenUtils.drawGradientRect(mat, 400, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, borderColorStart, borderColorStart);
            ScreenUtils.drawGradientRect(mat, 400, tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, borderColorEnd, borderColorEnd);
            class_4597.class_4598 renderType = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
            mStack.method_22904(0.0, 0.0, 400.0);
            int tooltipTop = tooltipY;
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                class_5348 line = textLines.get(lineNumber);
                if (line != null) {
                    font.method_22942(class_2477.method_10517().method_30934(line), (float)tooltipX, (float)tooltipY, -1, true, mat, (class_4597)renderType, class_327.class_6415.field_33993, 0, 0xF000F0);
                }
                if (lineNumber + 1 == n) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            renderType.method_22993();
            mStack.method_22909();
            RenderSystem.enableDepthTest();
        }
    }

    public static void drawContinuousTexturedBox(class_332 guiGraphics, class_2960 res, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder, float zLevel) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)res);
        ScreenUtils.drawContinuousTexturedBox(guiGraphics, x, y, u, v, width, height, textureWidth, textureHeight, topBorder, bottomBorder, leftBorder, rightBorder, zLevel);
    }

    public static void drawContinuousTexturedBox(class_332 guiGraphics, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder, float zLevel) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int fillerWidth = textureWidth - leftBorder - rightBorder;
        int fillerHeight = textureHeight - topBorder - bottomBorder;
        int canvasWidth = width - leftBorder - rightBorder;
        int canvasHeight = height - topBorder - bottomBorder;
        int xPasses = canvasWidth / fillerWidth;
        int remainderWidth = canvasWidth % fillerWidth;
        int yPasses = canvasHeight / fillerHeight;
        int remainderHeight = canvasHeight % fillerHeight;
        ScreenUtils.drawTexturedModalRect(guiGraphics, x, y, u, v, leftBorder, topBorder, zLevel);
        ScreenUtils.drawTexturedModalRect(guiGraphics, x + leftBorder + canvasWidth, y, u + leftBorder + fillerWidth, v, rightBorder, topBorder, zLevel);
        ScreenUtils.drawTexturedModalRect(guiGraphics, x, y + topBorder + canvasHeight, u, v + topBorder + fillerHeight, leftBorder, bottomBorder, zLevel);
        ScreenUtils.drawTexturedModalRect(guiGraphics, x + leftBorder + canvasWidth, y + topBorder + canvasHeight, u + leftBorder + fillerWidth, v + topBorder + fillerHeight, rightBorder, bottomBorder, zLevel);
        for (int i = 0; i < xPasses + (remainderWidth > 0 ? 1 : 0); ++i) {
            ScreenUtils.drawTexturedModalRect(guiGraphics, x + leftBorder + i * fillerWidth, y, u + leftBorder, v, i == xPasses ? remainderWidth : fillerWidth, topBorder, zLevel);
            ScreenUtils.drawTexturedModalRect(guiGraphics, x + leftBorder + i * fillerWidth, y + topBorder + canvasHeight, u + leftBorder, v + topBorder + fillerHeight, i == xPasses ? remainderWidth : fillerWidth, bottomBorder, zLevel);
            for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
                ScreenUtils.drawTexturedModalRect(guiGraphics, x + leftBorder + i * fillerWidth, y + topBorder + j * fillerHeight, u + leftBorder, v + topBorder, i == xPasses ? remainderWidth : fillerWidth, j == yPasses ? remainderHeight : fillerHeight, zLevel);
            }
        }
        for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
            ScreenUtils.drawTexturedModalRect(guiGraphics, x, y + topBorder + j * fillerHeight, u, v + topBorder, leftBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel);
            ScreenUtils.drawTexturedModalRect(guiGraphics, x + leftBorder + canvasWidth, y + topBorder + j * fillerHeight, u + leftBorder + fillerWidth, v + topBorder, rightBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel);
        }
    }

    public static void drawTexturedModalRect(class_332 guiGraphics, int x, int y, int u, int v, int width, int height, float zLevel) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        class_289 tessellator = class_289.method_1348();
        class_287 wr = tessellator.method_1349();
        wr.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        Matrix4f matrix = guiGraphics.method_51448().method_23760().method_23761();
        wr.method_22918(matrix, (float)x, (float)(y + height), zLevel).method_22913((float)u * 0.00390625f, (float)(v + height) * 0.00390625f).method_1344();
        wr.method_22918(matrix, (float)(x + width), (float)(y + height), zLevel).method_22913((float)(u + width) * 0.00390625f, (float)(v + height) * 0.00390625f).method_1344();
        wr.method_22918(matrix, (float)(x + width), (float)y, zLevel).method_22913((float)(u + width) * 0.00390625f, (float)v * 0.00390625f).method_1344();
        wr.method_22918(matrix, (float)x, (float)y, zLevel).method_22913((float)u * 0.00390625f, (float)v * 0.00390625f).method_1344();
        tessellator.method_1350();
    }
}

