/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.gameplay.overlay;

import io.sc3.plethora.Plethora;
import io.sc3.plethora.gameplay.PlethoraBlockTags;
import io.sc3.plethora.gameplay.modules.LevelableModuleItem;
import io.sc3.plethora.gameplay.overlay.FlareOverlayRenderer;
import io.sc3.plethora.util.config.PlethoraConfig;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ#\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ=\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJ'\u0010!\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b!\u0010\"R \u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0014\u0010)\u001a\u00020&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020+0*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0016\u0010.\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010/\u00a8\u00061"}, d2={"Lio/sc3/plethora/gameplay/overlay/ScannerOverlayRenderer;", "Lio/sc3/plethora/gameplay/overlay/FlareOverlayRenderer;", "<init>", "()V", "", "clearCache", "Lnet/minecraft/class_2248;", "block", "Lio/sc3/plethora/gameplay/overlay/FlareOverlayRenderer$FlareColor;", "getFlareColorByBlock", "(Lnet/minecraft/class_2248;)Lio/sc3/plethora/gameplay/overlay/FlareOverlayRenderer$FlareColor;", "Lnet/minecraft/class_2680;", "state", "", "isBlockOre", "(Lnet/minecraft/class_2680;Lnet/minecraft/class_2248;)Z", "Lnet/minecraft/class_746;", "player", "Lnet/minecraft/class_1799;", "stack", "Lnet/minecraft/class_4587;", "matrices", "", "tickDelta", "ticks", "Lnet/minecraft/class_4184;", "camera", "render", "(Lnet/minecraft/class_746;Lnet/minecraft/class_1799;Lnet/minecraft/class_4587;FFLnet/minecraft/class_4184;)V", "Lnet/minecraft/class_1937;", "world", "Lnet/minecraft/class_2338;", "pos", "scanBlocks", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Lnet/minecraft/class_1799;)V", "", "blockColorCache", "Ljava/util/Map;", "Lio/sc3/plethora/util/config/PlethoraConfig$Scanner;", "getCfg", "()Lio/sc3/plethora/util/config/PlethoraConfig$Scanner;", "cfg", "", "Lio/sc3/plethora/gameplay/overlay/ScannerOverlayRenderer$BlockResult;", "scanResults", "Ljava/util/List;", "scanTimer", "F", "BlockResult", "Plethora-Fabric"})
public final class ScannerOverlayRenderer
extends FlareOverlayRenderer {
    @NotNull
    public static final ScannerOverlayRenderer INSTANCE = new ScannerOverlayRenderer();
    @NotNull
    private static final Map<class_2248, FlareOverlayRenderer.FlareColor> blockColorCache = new LinkedHashMap();
    @NotNull
    private static final List<BlockResult> scanResults = new ArrayList();
    private static float scanTimer;

    private ScannerOverlayRenderer() {
    }

    private final PlethoraConfig.Scanner getCfg() {
        return Plethora.config.scanner;
    }

    public final void render(@NotNull class_746 player, @NotNull class_1799 stack, @NotNull class_4587 matrices, float tickDelta, float ticks, @NotNull class_4184 camera) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        FlareOverlayRenderer.Companion.initFlareRenderer(matrices, camera);
        scanTimer += tickDelta;
        if (scanTimer >= 10.0f) {
            class_1937 class_19372 = player.method_37908();
            Intrinsics.checkNotNullExpressionValue((Object)class_19372, (String)"getWorld(...)");
            class_2338 class_23382 = player.method_24515();
            Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"getBlockPos(...)");
            this.scanBlocks(class_19372, class_23382, stack);
            scanTimer = 0.0f;
        }
        for (BlockResult result : scanResults) {
            FlareOverlayRenderer.Companion.renderFlare(matrices, camera, ticks, (double)result.getX() + 0.5, (double)result.getY() + 0.5, (double)result.getZ() + 0.5, result.getColor(), 1.0f);
        }
        FlareOverlayRenderer.Companion.uninitFlareRenderer(matrices);
    }

    private final void scanBlocks(class_1937 world, class_2338 pos, class_1799 stack) {
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        int range = LevelableModuleItem.Companion.getEffectiveRange$default(LevelableModuleItem.Companion, stack, 0, 2, null);
        scanResults.clear();
        int oX = x - range;
        int n = x + range;
        if (oX <= n) {
            while (true) {
                int n2;
                int oY;
                if ((oY = y - range) <= (n2 = y + range)) {
                    while (true) {
                        int n3;
                        int oZ;
                        if ((oZ = z - range) <= (n3 = z + range)) {
                            while (true) {
                                class_2248 block;
                                class_2680 state;
                                if (this.isBlockOre(state = world.method_8320(new class_2338(oX, oY, oZ)), block = state.method_26204())) {
                                    Intrinsics.checkNotNull((Object)block);
                                    scanResults.add(new BlockResult(oX, oY, oZ, this.getFlareColorByBlock(block)));
                                }
                                if (oZ == n3) break;
                                ++oZ;
                            }
                        }
                        if (oY == n2) break;
                        ++oY;
                    }
                }
                if (oX == n) break;
                ++oX;
            }
        }
    }

    private final boolean isBlockOre(class_2680 state, class_2248 block) {
        if (state == null || block == null || state.method_26215()) {
            return false;
        }
        return state.method_26164(PlethoraBlockTags.INSTANCE.getBLOCK_SCANNER_ORES());
    }

    private final FlareOverlayRenderer.FlareColor getFlareColorByBlock(class_2248 block) {
        FlareOverlayRenderer.FlareColor flareColor = blockColorCache.computeIfAbsent(block, arg_0 -> ScannerOverlayRenderer.getFlareColorByBlock$lambda$0((Function1)new Function1<class_2248, FlareOverlayRenderer.FlareColor>(block){
            final /* synthetic */ class_2248 $block;
            {
                this.$block = $block;
                super(1);
            }

            public final FlareOverlayRenderer.FlareColor invoke(class_2248 it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                class_2960 class_29602 = class_7923.field_41175.method_10221((Object)this.$block);
                Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"getId(...)");
                class_2960 id = class_29602;
                return FlareOverlayRenderer.Companion.getFlareColorById(ScannerOverlayRenderer.access$getCfg((ScannerOverlayRenderer)ScannerOverlayRenderer.INSTANCE).oreColours, id);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flareColor, (String)"computeIfAbsent(...)");
        return flareColor;
    }

    public final void clearCache() {
        blockColorCache.clear();
        scanResults.clear();
        scanTimer = 0.0f;
    }

    private static final FlareOverlayRenderer.FlareColor getFlareColorByBlock$lambda$0(Function1 $tmp0, Object p0) {
        return (FlareOverlayRenderer.FlareColor)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ PlethoraConfig.Scanner access$getCfg(ScannerOverlayRenderer $this) {
        return $this.getCfg();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\u000bJ\u0010\u0010\r\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ8\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0014\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u000bJ\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001a\u001a\u0004\b\u001b\u0010\u000fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001c\u001a\u0004\b\u001d\u0010\u000bR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001c\u001a\u0004\b\u001e\u0010\u000bR\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001c\u001a\u0004\b\u001f\u0010\u000b\u00a8\u0006 "}, d2={"Lio/sc3/plethora/gameplay/overlay/ScannerOverlayRenderer$BlockResult;", "", "", "x", "y", "z", "Lio/sc3/plethora/gameplay/overlay/FlareOverlayRenderer$FlareColor;", "color", "<init>", "(IIILio/sc3/plethora/gameplay/overlay/FlareOverlayRenderer$FlareColor;)V", "component1", "()I", "component2", "component3", "component4", "()Lio/sc3/plethora/gameplay/overlay/FlareOverlayRenderer$FlareColor;", "copy", "(IIILio/sc3/plethora/gameplay/overlay/FlareOverlayRenderer$FlareColor;)Lio/sc3/plethora/gameplay/overlay/ScannerOverlayRenderer$BlockResult;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "Lio/sc3/plethora/gameplay/overlay/FlareOverlayRenderer$FlareColor;", "getColor", "I", "getX", "getY", "getZ", "Plethora-Fabric"})
    public static final class BlockResult {
        private final int x;
        private final int y;
        private final int z;
        @NotNull
        private final FlareOverlayRenderer.FlareColor color;

        public BlockResult(int x, int y, int z, @NotNull FlareOverlayRenderer.FlareColor color) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            this.x = x;
            this.y = y;
            this.z = z;
            this.color = color;
        }

        public final int getX() {
            return this.x;
        }

        public final int getY() {
            return this.y;
        }

        public final int getZ() {
            return this.z;
        }

        @NotNull
        public final FlareOverlayRenderer.FlareColor getColor() {
            return this.color;
        }

        public final int component1() {
            return this.x;
        }

        public final int component2() {
            return this.y;
        }

        public final int component3() {
            return this.z;
        }

        @NotNull
        public final FlareOverlayRenderer.FlareColor component4() {
            return this.color;
        }

        @NotNull
        public final BlockResult copy(int x, int y, int z, @NotNull FlareOverlayRenderer.FlareColor color) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            return new BlockResult(x, y, z, color);
        }

        public static /* synthetic */ BlockResult copy$default(BlockResult blockResult, int n, int n2, int n3, FlareOverlayRenderer.FlareColor flareColor, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = blockResult.x;
            }
            if ((n4 & 2) != 0) {
                n2 = blockResult.y;
            }
            if ((n4 & 4) != 0) {
                n3 = blockResult.z;
            }
            if ((n4 & 8) != 0) {
                flareColor = blockResult.color;
            }
            return blockResult.copy(n, n2, n3, flareColor);
        }

        @NotNull
        public String toString() {
            return "BlockResult(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", color=" + this.color + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.x);
            result = result * 31 + Integer.hashCode(this.y);
            result = result * 31 + Integer.hashCode(this.z);
            result = result * 31 + this.color.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BlockResult)) {
                return false;
            }
            BlockResult blockResult = (BlockResult)other;
            if (this.x != blockResult.x) {
                return false;
            }
            if (this.y != blockResult.y) {
                return false;
            }
            if (this.z != blockResult.z) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.color, (Object)blockResult.color);
        }
    }
}

