/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.gameplay.modules.glasses.objects.object2d;

import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import io.sc3.plethora.gameplay.modules.glasses.canvas.CanvasClient;
import io.sc3.plethora.gameplay.modules.glasses.objects.BaseObject;
import io.sc3.plethora.gameplay.modules.glasses.objects.ColourableObject;
import io.sc3.plethora.gameplay.modules.glasses.objects.object2d.MultiPoint2d;
import io.sc3.plethora.util.ByteBufUtils;
import io.sc3.plethora.util.Vec2d;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J)\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0017\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0014\u001a\n \u0013*\u0004\u0018\u00010\u00120\u00122\u0006\u0010\u0011\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u0019R\"\u0010\u001f\u001a\u0010\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u00120\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0014\u0010#\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006$"}, d2={"Lio/sc3/plethora/gameplay/modules/glasses/objects/object2d/Triangle2d;", "Lio/sc3/plethora/gameplay/modules/glasses/objects/ColourableObject;", "Lio/sc3/plethora/gameplay/modules/glasses/objects/object2d/MultiPoint2d;", "", "id", "parent", "<init>", "(II)V", "Lio/sc3/plethora/gameplay/modules/glasses/canvas/CanvasClient;", "canvas", "Lnet/minecraft/class_332;", "ctx", "Lnet/minecraft/class_4597;", "consumers", "", "draw", "(Lio/sc3/plethora/gameplay/modules/glasses/canvas/CanvasClient;Lnet/minecraft/class_332;Lnet/minecraft/class_4597;)V", "idx", "Lio/sc3/plethora/util/Vec2d;", "kotlin.jvm.PlatformType", "getPoint", "(I)Lio/sc3/plethora/util/Vec2d;", "Lnet/minecraft/class_2540;", "buf", "readInitial", "(Lnet/minecraft/class_2540;)V", "point", "setVertex", "(ILio/sc3/plethora/util/Vec2d;)V", "writeInitial", "", "points", "[Lio/sc3/plethora/util/Vec2d;", "getVertices", "()I", "vertices", "Plethora-Fabric"})
public final class Triangle2d
extends ColourableObject
implements MultiPoint2d {
    @NotNull
    private final Vec2d[] points;

    public Triangle2d(int id, int parent) {
        super(id, parent, (byte)4);
        Vec2d[] vec2dArray = new Vec2d[]{Vec2d.ZERO, Vec2d.ZERO, Vec2d.ZERO};
        this.points = vec2dArray;
        Arrays.fill(this.points, Vec2d.ZERO);
    }

    @Override
    public Vec2d getPoint(int idx) {
        return this.points[idx];
    }

    @Override
    public void setVertex(int idx, @NotNull Vec2d point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        if (!Objects.equal((Object)this.points[idx], (Object)point)) {
            this.points[idx] = point;
            this.setDirty();
        }
    }

    @Override
    public int getVertices() {
        return 3;
    }

    @Override
    public void writeInitial(@NotNull class_2540 buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super.writeInitial(buf);
        for (Vec2d point : this.points) {
            ByteBufUtils.writeVec2d((ByteBuf)buf, point);
        }
    }

    @Override
    public void readInitial(@NotNull class_2540 buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super.readInitial(buf);
        int n = this.points.length;
        for (int i2 = 0; i2 < n; ++i2) {
            this.points[i2] = ByteBufUtils.readVec2d((ByteBuf)buf);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void draw(@NotNull CanvasClient canvas, @NotNull class_332 ctx, @Nullable class_4597 consumers) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        BaseObject.setupFlat();
        class_4587 matrices = ctx.method_51448();
        class_287 buffer = class_289.method_1348().method_1349();
        Matrix4f matrix = matrices.method_23760().method_23761();
        buffer.method_1328(class_293.class_5596.field_27379, class_290.field_1576);
        buffer.method_22918(matrix, (float)this.points[0].x(), (float)this.points[0].y(), 0.0f).method_1336(this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha()).method_1344();
        buffer.method_22918(matrix, (float)this.points[1].x(), (float)this.points[1].y(), 0.0f).method_1336(this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha()).method_1344();
        buffer.method_22918(matrix, (float)this.points[2].x(), (float)this.points[2].y(), 0.0f).method_1336(this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha()).method_1344();
        class_286.method_43433((class_287.class_7433)buffer.method_1326());
    }
}

