/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.core.executor;

import io.sc3.plethora.core.executor.Task;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class TaskRunner {
    public static final TaskRunner SHARED = new TaskRunner();
    private static final int MAX_TASKS_TOTAL = 5000;
    private static final int MAX_TASKS_TICK = 50;
    private final Set<Task> tasks = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicLong tasksIssued = new AtomicLong(0L);

    public void update() {
        Iterator<Task> tasks = this.tasks.iterator();
        int i2 = 0;
        while (tasks.hasNext()) {
            if (tasks.next().update()) {
                tasks.remove();
            }
            if (i2++ <= 50) continue;
            break;
        }
    }

    boolean submit(Task task) {
        return this.tasks.size() <= 5000 && this.tasks.add(task);
    }

    public void reset() {
        this.tasks.clear();
    }

    public long getNewTaskId() {
        return this.tasksIssued.incrementAndGet();
    }
}

