/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.core.executor;

import dan200.computercraft.api.lua.ILuaCallback;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.WorkMonitor;
import io.sc3.plethora.api.method.FutureMethodResult;
import io.sc3.plethora.api.method.IResultExecutor;
import io.sc3.plethora.core.executor.Task;
import io.sc3.plethora.core.executor.TaskRunner;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ComputerAccessExecutor
implements IResultExecutor {
    private static final String EVENT_NAME = "plethora_task";
    private final IComputerAccess access;
    private final String attachmentName;
    private final TaskRunner runner;
    private volatile boolean attached;

    public ComputerAccessExecutor(IComputerAccess access, TaskRunner runner) {
        this.access = access;
        this.attachmentName = access.getAttachmentName();
        this.runner = runner;
    }

    @Override
    @Nullable
    public MethodResult execute(@Nonnull FutureMethodResult result, @Nonnull ILuaContext context) throws LuaException {
        this.assertAttached();
        if (result.isFinal()) {
            return result.getResult();
        }
        long taskId = this.runner.getNewTaskId();
        ComputerTask task = new ComputerTask(this, result.getCallback(), result.getResolver(), true, taskId);
        boolean ok = this.runner.submit(task);
        if (!ok) {
            throw new LuaException("Task limit exceeded");
        }
        return new ComputerTaskCallback((long)taskId, (Task)task, (ComputerTaskCallback.TaskBody)(ComputerTaskCallback.TaskBody)LambdaMetafactory.metafactory(null, null, null, ()V, assertAttached(), ()V)((ComputerAccessExecutor)this)).pull;
    }

    @Override
    public void executeAsync(@Nonnull FutureMethodResult result) throws LuaException {
        this.assertAttached();
        if (result.isFinal()) {
            return;
        }
        long taskId = this.runner.getNewTaskId();
        ComputerTask task = new ComputerTask(this, result.getCallback(), result.getResolver(), false, taskId);
        boolean ok = this.runner.submit(task);
        if (!ok) {
            task.cancel();
            throw new LuaException("Task limit exceeded");
        }
    }

    private void assertAttached() throws LuaException {
        if (!this.attached) {
            throw new LuaException("Peripheral '" + this.attachmentName + "' is no longer attached");
        }
    }

    public void attach() {
        this.attached = true;
    }

    public void detach() {
        this.attached = false;
    }

    private static class ComputerTask
    extends Task {
        private final WorkMonitor monitor;
        private final ComputerAccessExecutor executor;
        private final boolean shouldQueue;
        private final long taskId;

        ComputerTask(ComputerAccessExecutor executor, Callable<FutureMethodResult> callback, FutureMethodResult.Resolver resolver, boolean shouldQueue, long taskId) {
            super(callback, resolver);
            this.executor = executor;
            this.shouldQueue = shouldQueue;
            this.taskId = taskId;
            this.monitor = executor.access.getMainThreadMonitor();
        }

        @Override
        void whenDone() {
            super.whenDone();
            if (!this.executor.attached || !this.shouldQueue) {
                return;
            }
            try {
                this.executor.access.queueEvent(ComputerAccessExecutor.EVENT_NAME, new Object[]{this.taskId});
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        @Override
        boolean canWork() {
            return this.monitor == null || this.monitor.shouldWork();
        }

        @Override
        protected void submitTiming(long time) {
            super.submitTiming(time);
            if (this.monitor != null) {
                this.monitor.trackWork(time, TimeUnit.NANOSECONDS);
            }
        }

        @Override
        public boolean update() {
            if (!this.executor.attached) {
                this.cancel();
                return true;
            }
            return super.update();
        }
    }

    private static final class ComputerTaskCallback
    implements ILuaCallback {
        private final MethodResult pull = MethodResult.pullEvent((String)"plethora_task", (ILuaCallback)this);
        private final long taskId;
        private final Task originalTask;
        private TaskBody assertAttached;

        private ComputerTaskCallback(long taskId, Task originalTask, TaskBody assertAttached) {
            this.taskId = taskId;
            this.originalTask = originalTask;
            this.assertAttached = assertAttached;
        }

        @Nonnull
        public MethodResult resume(Object[] response) throws LuaException {
            Object object;
            if (response.length < 2 || !((object = response[1]) instanceof Number)) {
                return this.pull;
            }
            Number id = (Number)object;
            if (id.longValue() != this.taskId) {
                return this.pull;
            }
            this.assertAttached.run();
            if (!this.originalTask.isDone()) {
                return this.pull;
            }
            if (this.originalTask.error != null) {
                throw this.originalTask.error;
            }
            if (this.originalTask.result != null) {
                return this.originalTask.result;
            }
            return MethodResult.of();
        }

        @FunctionalInterface
        private static interface TaskBody {
            public void run() throws LuaException;
        }
    }
}

