/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.core.executor;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaTask;
import dan200.computercraft.api.lua.MethodResult;
import io.sc3.plethora.Plethora;
import io.sc3.plethora.api.method.FutureMethodResult;
import io.sc3.plethora.api.method.IResultExecutor;
import io.sc3.plethora.core.executor.Task;
import io.sc3.plethora.core.executor.TaskRunner;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class BasicExecutor
implements IResultExecutor {
    public static final BasicExecutor INSTANCE = new BasicExecutor();

    private BasicExecutor() {
    }

    @Override
    @Nullable
    public MethodResult execute(@Nonnull FutureMethodResult result, @Nonnull ILuaContext context) throws LuaException {
        if (result.isFinal()) {
            return result.getResult();
        }
        BlockingTask task = new BlockingTask(result.getResolver(), result.getCallback());
        return context.executeMainThreadTask((LuaTask)task);
    }

    @Override
    public void executeAsync(@Nonnull FutureMethodResult result) throws LuaException {
        if (result.isFinal()) {
            return;
        }
        Task task = new Task(result.getCallback(), result.getResolver());
        boolean ok = TaskRunner.SHARED.submit(task);
        if (!ok) {
            task.cancel();
            throw new LuaException("Task limit exceeded");
        }
    }

    private static class BlockingTask
    implements LuaTask {
        private FutureMethodResult.Resolver resolver;
        private Callable<FutureMethodResult> callback;

        BlockingTask(FutureMethodResult.Resolver resolver, Callable<FutureMethodResult> callback) {
            this.resolver = resolver;
            this.callback = callback;
        }

        public Object[] execute() throws LuaException {
            while (this.resolver.update()) {
                this.resolver = null;
                try {
                    FutureMethodResult result = this.callback.call();
                    if (result.isFinal()) {
                        return result.getResult().getResult();
                    }
                    this.resolver = result.getResolver();
                    this.callback = result.getCallback();
                }
                catch (LuaException e) {
                    throw e;
                }
                catch (Exception | LinkageError | VirtualMachineError e) {
                    Plethora.log.error("Unexpected error", e);
                    throw new LuaException("Java Exception Thrown: " + String.valueOf(e));
                }
            }
            return null;
        }

        boolean done() {
            return this.resolver == null;
        }
    }
}

