/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.core.collections;

import com.google.common.collect.Queues;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import javax.annotation.Nonnull;

public class ClassIteratorIterable
implements Iterable<Class<?>>,
Iterator<Class<?>> {
    private final HashSet<Class<?>> visited = new HashSet();
    private final Queue<Class<?>> toVisit = Queues.newArrayDeque();

    public ClassIteratorIterable(Class<?> root) {
        this.visited.add(root);
        this.toVisit.add(root);
    }

    @Override
    @Nonnull
    public Iterator<Class<?>> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return !this.toVisit.isEmpty();
    }

    @Override
    public Class<?> next() {
        Class<?> klass = this.toVisit.remove();
        Class<?> parent = klass.getSuperclass();
        if (parent != null && this.visited.add(parent)) {
            this.toVisit.add(parent);
        }
        for (Class<?> iface : klass.getInterfaces()) {
            if (iface == null || !this.visited.add(iface)) continue;
            this.toVisit.add(iface);
        }
        return klass;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

