/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.core;

import dan200.computercraft.api.lua.LuaException;
import io.sc3.plethora.api.method.ICostHandler;
import io.sc3.plethora.api.method.IResultExecutor;
import io.sc3.plethora.api.method.IUnbakedContext;
import io.sc3.plethora.api.module.IModuleContainer;
import io.sc3.plethora.api.reference.IReference;
import io.sc3.plethora.core.Context;
import io.sc3.plethora.core.ConverterReference;
import javax.annotation.Nonnull;

public final class UnbakedContext<T>
implements IUnbakedContext<T> {
    final int target;
    final String[] keys;
    final Object[] references;
    final ICostHandler handler;
    final IReference<IModuleContainer> modules;
    final IResultExecutor executor;

    UnbakedContext(int target, String[] keys, Object[] references, ICostHandler handler, IReference<IModuleContainer> modules, IResultExecutor executor) {
        this.target = target;
        this.handler = handler;
        this.keys = keys;
        this.references = references;
        this.modules = modules;
        this.executor = executor;
    }

    UnbakedContext<?> withIndex(int index) {
        return index == this.target ? this : new UnbakedContext<T>(index, this.keys, this.references, this.handler, this.modules, this.executor);
    }

    @Override
    @Nonnull
    public Context<T> bake() throws LuaException {
        Object[] values = new Object[this.references.length];
        for (int i2 = 0; i2 < this.references.length; ++i2) {
            Object reference = this.references[i2];
            values[i2] = reference instanceof IReference ? ((IReference)reference).get() : (reference instanceof ConverterReference ? ((ConverterReference)reference).tryConvert(values) : reference);
        }
        return new Context(this, values, this.modules.get());
    }

    @Override
    @Nonnull
    public Context<T> safeBake() throws LuaException {
        Object[] values = new Object[this.references.length];
        for (int i2 = 0; i2 < this.references.length; ++i2) {
            Object reference = this.references[i2];
            values[i2] = reference instanceof IReference ? ((IReference)reference).safeGet() : (reference instanceof ConverterReference ? null : reference);
        }
        return new Context(this, values, this.modules.safeGet());
    }

    @Override
    @Nonnull
    public ICostHandler getCostHandler() {
        return this.handler;
    }

    @Override
    @Nonnull
    public IResultExecutor getExecutor() {
        return this.executor;
    }
}

