/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.core;

import com.google.common.collect.Multimap;
import io.sc3.plethora.core.RegisteredValue;
import io.sc3.plethora.core.collections.SortedMultimap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TargetedRegisteredValue<T>
extends RegisteredValue {
    private final Class<?> target;
    private final T value;

    TargetedRegisteredValue(@Nonnull String name, @Nullable String mod, @Nonnull Class<?> target, @Nonnull T value) {
        super(name, mod);
        this.target = target;
        this.value = value;
    }

    @Nonnull
    final Class<?> target() {
        return this.target;
    }

    @Nonnull
    final T value() {
        return this.value;
    }

    static <T> void buildCache(Iterable<TargetedRegisteredValue<? extends T>> all, Multimap<Class<?>, T> cache) {
        cache.clear();
        for (TargetedRegisteredValue<T> item2 : all) {
            if (!item2.enabled()) continue;
            cache.put(item2.target(), item2.value());
        }
    }

    static <T> void buildCache(Iterable<TargetedRegisteredValue<? extends T>> all, SortedMultimap<Class<?>, T> cache) {
        cache.clear();
        for (TargetedRegisteredValue<T> item2 : all) {
            if (!item2.enabled()) continue;
            cache.put(item2.target(), item2.value());
        }
    }
}

