/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.core;

import io.sc3.plethora.Plethora;
import io.sc3.plethora.api.PlethoraAPI;
import io.sc3.plethora.api.PlethoraEvents;
import io.sc3.plethora.core.ConverterRegistry;
import io.sc3.plethora.core.DefaultCostHandler;
import io.sc3.plethora.core.MetaRegistry;
import io.sc3.plethora.core.MethodRegistry;
import io.sc3.plethora.core.executor.TaskRunner;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;

public class PlethoraCore {
    public static void initializeCore() {
        Plethora.log.info("Plethora core initializing");
        Plethora.log.info("Beginning Plethora registration");
        ((PlethoraEvents.Register)PlethoraEvents.REGISTER.invoker()).onRegister(PlethoraAPI.instance());
        PlethoraCore.buildRegistries();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            Plethora.log.info("Server started, resetting shared task runner");
            TaskRunner.SHARED.reset();
        });
        ServerTickEvents.START_SERVER_TICK.register(server -> {
            DefaultCostHandler.update();
            TaskRunner.SHARED.update();
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            Plethora.log.info("Server stopped, resetting cost handler and shared task runner");
            DefaultCostHandler.reset();
            TaskRunner.SHARED.reset();
        });
    }

    static void buildRegistries() {
        Plethora.log.info("Building converter registry");
        ConverterRegistry.instance.build();
        Plethora.log.info("Building meta registry");
        MetaRegistry.instance.build();
        Plethora.log.info("Building method registry");
        MethodRegistry.instance.build();
    }
}

