/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.core;

import io.sc3.plethora.api.meta.TypedMeta;
import io.sc3.plethora.api.method.ICostHandler;
import io.sc3.plethora.api.method.IPartialContext;
import io.sc3.plethora.api.module.IModuleContainer;
import io.sc3.plethora.core.ConverterRegistry;
import io.sc3.plethora.core.MetaRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nonnull;

public class PartialContext<T>
implements IPartialContext<T> {
    protected final int target;
    protected final String[] keys;
    protected final Object[] values;
    protected final ICostHandler handler;
    protected final IModuleContainer modules;

    public PartialContext(int target, String[] keys, @Nonnull Object[] values, @Nonnull ICostHandler handler, @Nonnull IModuleContainer modules) {
        this.target = target;
        this.keys = keys;
        this.handler = handler;
        this.values = values;
        this.modules = modules;
    }

    @Override
    @Nonnull
    public T getTarget() {
        return (T)this.values[this.target];
    }

    PartialContext<?> withIndex(int index) {
        return index == this.target ? this : new PartialContext<T>(index, this.keys, this.values, this.handler, this.modules);
    }

    @Override
    public <V> V getContext(@Nonnull Class<V> klass) {
        Objects.requireNonNull(klass, "klass cannot be null");
        for (int i2 = this.values.length - 1; i2 >= 0; --i2) {
            Object obj = this.values[i2];
            if (!klass.isInstance(obj)) continue;
            return (V)obj;
        }
        return null;
    }

    @Override
    public <V> boolean hasContext(@Nonnull Class<V> klass) {
        Objects.requireNonNull(klass, "klass cannot be null");
        for (int i2 = this.values.length - 1; i2 >= 0; --i2) {
            Object obj = this.values[i2];
            if (!klass.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <V> V getContext(@Nonnull String contextKey, @Nonnull Class<V> klass) {
        Objects.requireNonNull(contextKey, "contextKey cannot be null");
        Objects.requireNonNull(klass, "klass cannot be null");
        for (int i2 = this.values.length - 1; i2 >= 0; --i2) {
            Object obj = this.values[i2];
            if (!contextKey.equals(this.keys[i2]) || !klass.isInstance(obj)) continue;
            return (V)obj;
        }
        return null;
    }

    @Override
    public <V> boolean hasContext(@Nonnull String contextKey, @Nonnull Class<V> klass) {
        Objects.requireNonNull(klass, "klass cannot be null");
        for (int i2 = this.values.length - 1; i2 >= 0; --i2) {
            Object obj = this.values[i2];
            if (!contextKey.equals(this.keys[i2]) || !klass.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public <U> PartialContext<U> makePartialChild(@Nonnull U target) {
        Objects.requireNonNull(target, "target cannot be null");
        ArrayList<String> keys = new ArrayList<String>(this.keys.length + 1);
        ArrayList<Object> values = new ArrayList<Object>(this.values.length + 1);
        Collections.addAll(keys, this.keys);
        Collections.addAll(values, this.values);
        for (int i2 = keys.size() - 1; i2 >= 0; --i2) {
            if (!"target".equals(keys.get(i2))) continue;
            keys.set(i2, "generic");
        }
        keys.add("target");
        values.add(target);
        ConverterRegistry.instance.extendConverted(keys, values, this.values.length);
        return new PartialContext<T>(this.values.length, keys.toArray(new String[0]), values.toArray(), this.handler, this.modules);
    }

    @Override
    @Nonnull
    public ICostHandler getCostHandler() {
        return this.handler;
    }

    @Override
    @Nonnull
    public IModuleContainer getModules() {
        return this.modules;
    }

    @Override
    @Nonnull
    public TypedMeta<T, ?> getMeta() {
        return MetaRegistry.instance.getMeta(this);
    }
}

