/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.core;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IDynamicPeripheral;
import dan200.computercraft.api.peripheral.IPeripheral;
import io.sc3.plethora.Plethora;
import io.sc3.plethora.api.method.FutureMethodResult;
import io.sc3.plethora.api.method.IResultExecutor;
import io.sc3.plethora.core.MethodWrapper;
import io.sc3.plethora.core.RegisteredMethod;
import io.sc3.plethora.core.UnbakedContext;
import io.sc3.plethora.core.executor.ComputerAccessExecutor;
import io.sc3.plethora.core.executor.TaskRunner;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.class_3545;
import org.apache.commons.lang3.ObjectUtils;

public class MethodWrapperPeripheral
extends MethodWrapper
implements IDynamicPeripheral {
    private final Object owner;
    private final String type;
    private final TaskRunner runner;
    private final Map<IComputerAccess, ComputerAccessExecutor> accesses = new ConcurrentHashMap<IComputerAccess, ComputerAccessExecutor>();

    public MethodWrapperPeripheral(String name, Object owner, List<RegisteredMethod<?>> methods, List<UnbakedContext<?>> contexts, TaskRunner runner) {
        super(methods, contexts);
        this.owner = owner;
        this.type = name;
        this.runner = runner;
    }

    public MethodWrapperPeripheral(String name, Object owner, class_3545<List<RegisteredMethod<?>>, List<UnbakedContext<?>>> methods, TaskRunner runner) {
        this(name, owner, (List)methods.method_15442(), (List)methods.method_15441(), runner);
    }

    @Nonnull
    public String getType() {
        return this.type;
    }

    public MethodResult callMethod(@Nonnull IComputerAccess access, @Nonnull ILuaContext luaContext, int method, @Nonnull IArguments args) throws LuaException {
        IResultExecutor executor = this.accesses.get(access);
        if (executor == null) {
            throw new LuaException("Not attached to this computer");
        }
        UnbakedContext<?> context = this.getContext(method);
        Object[] extraRef = MethodWrapperPeripheral.getReferences(access, luaContext);
        int totalSize = context.keys.length + extraRef.length;
        String[] keys = new String[totalSize];
        System.arraycopy(context.keys, 0, keys, 0, context.keys.length);
        Object[] references = new Object[totalSize];
        System.arraycopy(context.references, 0, references, 0, context.references.length);
        for (int i2 = 0; i2 < extraRef.length; ++i2) {
            keys[context.keys.length + i2] = "computer";
            references[context.keys.length + i2] = extraRef[i2];
        }
        UnbakedContext full = new UnbakedContext(context.target, keys, references, context.handler, context.modules, executor);
        args.escapes();
        FutureMethodResult result = this.getMethod(method).call(full, args);
        MethodResult executorResult = executor.execute(result, luaContext);
        return (MethodResult)ObjectUtils.firstNonNull((Object[])new MethodResult[]{executorResult, MethodResult.of()});
    }

    public void attach(@Nonnull IComputerAccess access) {
        ComputerAccessExecutor executor = new ComputerAccessExecutor(access, this.runner);
        executor.attach();
        ComputerAccessExecutor previous = this.accesses.put(access, executor);
        if (previous != null) {
            previous.detach();
        }
    }

    public void detach(@Nonnull IComputerAccess access) {
        ComputerAccessExecutor executor = this.accesses.remove(access);
        if (executor != null) {
            executor.detach();
        }
    }

    public void queueEvent(@Nonnull String name, Object ... args) {
        for (IComputerAccess access : this.accesses.keySet()) {
            try {
                access.queueEvent(name, args);
            }
            catch (RuntimeException e) {
                Plethora.log.error("Cannot queue event on " + String.valueOf(access), (Throwable)e);
            }
        }
    }

    @Nonnull
    public TaskRunner getRunner() {
        return this.runner;
    }

    @Nonnull
    public Object getTarget() {
        return this.owner;
    }

    public boolean equals(IPeripheral other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MethodWrapperPeripheral)) {
            return false;
        }
        MethodWrapperPeripheral otherP = (MethodWrapperPeripheral)other;
        if (!this.getType().equals(other.getType())) {
            return false;
        }
        return this.owner == otherP.owner && this.equalMethods(otherP);
    }
}

