/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import io.sc3.plethora.Plethora;
import io.sc3.plethora.api.converter.IConverterExcludeMethod;
import io.sc3.plethora.api.method.IContext;
import io.sc3.plethora.api.method.ICostHandler;
import io.sc3.plethora.api.method.IMethod;
import io.sc3.plethora.api.method.IMethodRegistry;
import io.sc3.plethora.api.method.IPartialContext;
import io.sc3.plethora.core.Context;
import io.sc3.plethora.core.DefaultCostHandler;
import io.sc3.plethora.core.MethodCollection;
import io.sc3.plethora.core.RegisteredMethod;
import io.sc3.plethora.core.UnbakedContext;
import io.sc3.plethora.core.collections.ClassIteratorIterable;
import io.sc3.plethora.util.config.ConfigLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2350;
import net.minecraft.class_3545;

public final class MethodRegistry
implements IMethodRegistry {
    public static final MethodRegistry instance = new MethodRegistry();
    final List<RegisteredMethod<?>> all = new ArrayList();
    final Multimap<Class<?>, RegisteredMethod<?>> providers = MultimapBuilder.hashKeys().arrayListValues().build();

    private void registerMethod(@Nonnull RegisteredMethod<?> entry) {
        Objects.requireNonNull(entry, "entry cannot be null");
        if (entry.getTarget() == Object.class && entry.getMethod().has(IConverterExcludeMethod.class)) {
            Plethora.log.warn("You're registering a method (" + entry.getRegName() + ") targeting the base class (Object). Converters will probably mask the original object: it is recommended that you implement IConverterExcludeMethod to avoid this.");
        }
        this.all.add(entry);
    }

    @Override
    public <T> void registerMethod(@Nonnull String mod, @Nonnull String name, @Nonnull Class<T> target, @Nonnull IMethod<T> method) {
        Objects.requireNonNull(mod, "mod cannot be null");
        Objects.requireNonNull(name, "name cannot be null");
        Objects.requireNonNull(target, "target cannot be null");
        Objects.requireNonNull(method, "method cannot be null");
        Plethora.log.debug("Registering method {} for {}", (Object)(mod + ":" + name), target);
        this.registerMethod(new RegisteredMethod.Impl<T>(name, mod, target, method));
    }

    public void build() {
        Plethora.log.debug("Building method registry");
        this.providers.clear();
        for (RegisteredMethod<?> entry : this.all) {
            if (!entry.enabled()) continue;
            entry.build();
            this.providers.put(entry.getTarget(), entry);
        }
        Plethora.log.info("Updating base costs in configuration file");
        ConfigLoader.INSTANCE.saveConfig(Plethora.config);
    }

    @Nonnull
    public <T> List<RegisteredMethod<T>> getMethods(@Nonnull IPartialContext<T> context) {
        Objects.requireNonNull(context, "context cannot be null");
        ArrayList methods = Lists.newArrayList();
        for (Class<?> klass : new ClassIteratorIterable(context.getTarget().getClass())) {
            for (RegisteredMethod entry : this.providers.get(klass)) {
                if (!entry.getMethod().canApply(context)) continue;
                methods.add(entry);
            }
        }
        return Collections.unmodifiableList(methods);
    }

    @Override
    @Nonnull
    public ICostHandler getCostHandler(@Nonnull Object object, @Nullable class_2350 side) {
        Objects.requireNonNull(object, "object cannot be null");
        return DefaultCostHandler.get(object);
    }

    public class_3545<List<RegisteredMethod<?>>, List<UnbakedContext<?>>> getMethodsPaired(Context<?> builder) {
        int index;
        Integer existing;
        IMethod method;
        ArrayList methods = Lists.newArrayList();
        ArrayList contexts = Lists.newArrayList();
        HashMap<String, Integer> methodLookup = new HashMap<String, Integer>();
        String[] keys = builder.keys;
        Object[] values = builder.values;
        for (int i2 = values.length - 1; i2 >= 0; --i2) {
            if (!"target".equals(keys[i2])) continue;
            UnbakedContext<?> unbaked = null;
            for (RegisteredMethod entry : this.getMethods(builder.withIndex(i2))) {
                method = entry.getMethod();
                if (i2 != builder.target && method.has(IConverterExcludeMethod.class)) continue;
                if (unbaked == null) {
                    unbaked = ((UnbakedContext)builder.unbake()).withIndex(i2);
                }
                if ((existing = (Integer)methodLookup.get(method.getName())) != null) {
                    index = existing;
                    if (method.getPriority() <= ((RegisteredMethod)methods.get(index)).getMethod().getPriority()) continue;
                    methods.set(index, entry);
                    contexts.set(index, unbaked);
                    continue;
                }
                methods.add(entry);
                contexts.add(unbaked);
                methodLookup.put(method.getName(), methods.size() - 1);
            }
        }
        if (!methods.isEmpty()) {
            MethodCollection collection = new MethodCollection(methods);
            IContext baked = builder.makeChildId(collection);
            for (RegisteredMethod entry : this.getMethods(baked)) {
                method = entry.getMethod();
                existing = (Integer)methodLookup.get(method.getName());
                if (existing != null) {
                    index = existing;
                    if (method.getPriority() <= ((RegisteredMethod)methods.get(index)).getMethod().getPriority()) continue;
                    methods.set(index, entry);
                    contexts.set(index, ((Context)baked).unbake());
                    continue;
                }
                methods.add(entry);
                contexts.add(((Context)baked).unbake());
                methodLookup.put(method.getName(), methods.size() - 1);
            }
        }
        return new class_3545((Object)methods, (Object)contexts);
    }
}

