/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.core;

import com.google.common.collect.Lists;
import io.sc3.plethora.Plethora;
import io.sc3.plethora.api.meta.IMetaProvider;
import io.sc3.plethora.api.meta.IMetaRegistry;
import io.sc3.plethora.api.meta.TypedMeta;
import io.sc3.plethora.core.PartialContext;
import io.sc3.plethora.core.TargetedRegisteredValue;
import io.sc3.plethora.core.collections.ClassIteratorIterable;
import io.sc3.plethora.core.collections.SortedMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MetaRegistry
implements IMetaRegistry {
    public static final MetaRegistry instance = new MetaRegistry();
    private static final Map<IMetaProvider<?>, TargetedRegisteredValue<? extends IMetaProvider<?>>> all = new HashMap();
    final SortedMultimap<Class<?>, IMetaProvider<?>> providers = SortedMultimap.create(Comparator.comparingInt(IMetaProvider::getPriority));

    void registerMetaProvider(@Nonnull TargetedRegisteredValue<? extends IMetaProvider<?>> provider) {
        Objects.requireNonNull(provider, "provider cannot be null");
        all.put(provider.value(), provider);
    }

    @Override
    public <T extends IMetaProvider<?>> void registerMetaProvider(@Nonnull String name, @Nullable String mod, @Nonnull Class<?> target, @Nonnull T value) {
        Objects.requireNonNull(name, "name cannot be null");
        Objects.requireNonNull(target, "target cannot be null");
        Objects.requireNonNull(value, "value cannot be null");
        this.registerMetaProvider(new TargetedRegisteredValue<T>(name, mod, target, value));
    }

    void build() {
        TargetedRegisteredValue.buildCache(all.values(), this.providers);
    }

    public String getName(@Nonnull IMetaProvider<?> provider) {
        TargetedRegisteredValue<IMetaProvider<?>> item2 = all.get(provider);
        return item2 == null ? provider.getClass().getName() : item2.getRegName();
    }

    @Nonnull
    public <T> TypedMeta<T, ?> getMeta(@Nonnull PartialContext<T> context) {
        Objects.requireNonNull(context, "context cannot be null");
        String[] keys = context.keys;
        Object[] values = context.values;
        HashTypedMeta result = null;
        Map<String, ?> first = null;
        for (int i2 = values.length - 1; i2 >= 0; --i2) {
            if (!"target".equals(keys[i2])) continue;
            Object child = values[i2];
            PartialContext<?> childContext = context.withIndex(i2);
            for (IMetaProvider<?> provider : this.getMetaProviders(child.getClass())) {
                Map<String, ?> res = provider.getMeta(childContext);
                if (res == null) {
                    Plethora.log.error("Meta provider {} returned null", (Object)this.getName(provider));
                    continue;
                }
                if (res.isEmpty()) continue;
                if (result != null) {
                    result.putAll(res);
                    continue;
                }
                if (first != null) {
                    result = new HashTypedMeta(first.size() + res.size());
                    result.putAll(first);
                    result.putAll(res);
                    continue;
                }
                first = res;
            }
        }
        if (result != null) {
            return result;
        }
        if (first != null) {
            return new WrapperTypedMeta(first);
        }
        return WrapperTypedMeta.empty();
    }

    @Override
    @Nonnull
    public List<IMetaProvider<?>> getMetaProviders(@Nonnull Class<?> target) {
        Objects.requireNonNull(target, "target cannot be null");
        ArrayList result = Lists.newArrayList();
        for (Class<?> klass : new ClassIteratorIterable(target)) {
            result.addAll(this.providers.get(klass));
        }
        return Collections.unmodifiableList(result);
    }

    private static class HashTypedMeta<T, V>
    extends HashMap<String, V>
    implements TypedMeta<T, V> {
        private static final long serialVersionUID = 2925566988195565014L;

        HashTypedMeta(int initialCapacity) {
            super(initialCapacity);
        }

        public HashTypedMeta(Map<? extends String, ? extends V> m) {
            super(m);
        }
    }

    private static final class WrapperTypedMeta<T, V>
    implements TypedMeta<T, V> {
        private static final WrapperTypedMeta<?, ?> EMPTY = new WrapperTypedMeta(Collections.emptyMap());
        private final Map<String, V> wrapper;

        public static <T> TypedMeta<T, ?> empty() {
            return EMPTY;
        }

        WrapperTypedMeta(Map<String, V> wrapper) {
            this.wrapper = wrapper;
        }

        @Override
        public int size() {
            return this.wrapper.size();
        }

        @Override
        public boolean isEmpty() {
            return this.wrapper.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.wrapper.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.wrapper.containsValue(value);
        }

        @Override
        public V get(Object key) {
            return this.wrapper.get(key);
        }

        @Override
        public V put(String key, V value) {
            return this.wrapper.put(key, value);
        }

        @Override
        public V remove(Object key) {
            return this.wrapper.remove(key);
        }

        @Override
        public void putAll(@Nonnull Map<? extends String, ? extends V> m) {
            this.wrapper.putAll(m);
        }

        @Override
        public void clear() {
            this.wrapper.clear();
        }

        @Override
        @Nonnull
        public Set<String> keySet() {
            return this.wrapper.keySet();
        }

        @Override
        @Nonnull
        public Collection<V> values() {
            return this.wrapper.values();
        }

        @Override
        @Nonnull
        public Set<Map.Entry<String, V>> entrySet() {
            return this.wrapper.entrySet();
        }
    }
}

