/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.core;

import com.google.common.base.Strings;
import dan200.computercraft.api.lua.LuaException;
import io.sc3.plethora.api.converter.ConstantConverter;
import io.sc3.plethora.api.converter.IConverter;

public class ConverterReference<T> {
    private static final ConstantConverter<Object, Object> identity = x -> x;
    private final int index;
    private final Class<T> tIn;
    private final IConverter<T, ?> converter;

    public ConverterReference(int index, Class<T> tIn, IConverter<T, ?> converter) {
        this.index = index;
        this.tIn = tIn;
        this.converter = converter;
    }

    public static ConverterReference<Object> identity(int index) {
        return new ConverterReference<Object>(index, Object.class, identity);
    }

    public boolean isIdentity() {
        return this.converter == identity;
    }

    public Object tryConvert(Object[] values) throws LuaException {
        Object converted;
        Object value = values[this.index];
        if (value != null && this.tIn.isAssignableFrom(value.getClass()) && (converted = this.converter.convert(value)) != null) {
            return converted;
        }
        String name = this.converter.getClass().getSimpleName();
        if (Strings.isNullOrEmpty((String)name)) {
            name = this.converter.getClass().getName();
        }
        throw new LuaException("Cannot find object for " + name);
    }
}

