/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.api.module;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import io.sc3.plethora.api.method.FutureMethodResult;
import io.sc3.plethora.api.method.IMethod;
import io.sc3.plethora.api.method.IPartialContext;
import io.sc3.plethora.api.method.IUnbakedContext;
import io.sc3.plethora.api.module.IModuleContainer;
import io.sc3.plethora.api.module.ModuleContainerMethod;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.class_2960;

public abstract class SubtargetedModuleMethod<T>
extends ModuleContainerMethod {
    private final Class<T> klass;

    public SubtargetedModuleMethod(String name, Set<class_2960> modules, Class<T> klass, String docs) {
        this(name, modules, klass, 0, docs);
    }

    public SubtargetedModuleMethod(String name, Set<class_2960> modules, Class<T> klass, int priority, String docs) {
        super(name, modules, priority, docs);
        this.klass = klass;
    }

    @Nonnull
    public static <T> SubtargetedModuleMethod<T> of(String name, Set<class_2960> modules, Class<T> klass, String docs, final IMethod.Delegate<IModuleContainer> delegate, final boolean worldThread) {
        return new SubtargetedModuleMethod<T>(name, modules, klass, docs){

            @Override
            @Nonnull
            public FutureMethodResult apply(@Nonnull IUnbakedContext<IModuleContainer> context, @Nonnull IArguments args) throws LuaException {
                return worldThread ? FutureMethodResult.nextTick(() -> delegate.apply(context, args)) : delegate.apply(context, args);
            }
        };
    }

    @Nonnull
    public static <T> SubtargetedModuleMethod<T> of(String name, class_2960 module, Class<T> klass, String docs, IMethod.Delegate<IModuleContainer> delegate, boolean worldThread) {
        return SubtargetedModuleMethod.of(name, Collections.singleton(module), klass, docs, delegate, worldThread);
    }

    @Nonnull
    public static <T> SubtargetedModuleMethod<T> of(String name, Set<class_2960> modules, Class<T> klass, String docs, IMethod.Delegate<IModuleContainer> delegate) {
        return SubtargetedModuleMethod.of(name, modules, klass, docs, delegate, true);
    }

    @Nonnull
    public static <T> SubtargetedModuleMethod<T> of(String name, class_2960 module, Class<T> klass, String docs, IMethod.Delegate<IModuleContainer> delegate) {
        return SubtargetedModuleMethod.of(name, module, klass, docs, delegate, true);
    }

    @Override
    public boolean canApply(@Nonnull IPartialContext<IModuleContainer> context) {
        if (!super.canApply(context)) {
            return false;
        }
        if (context.hasContext("origin", this.klass)) {
            return true;
        }
        for (class_2960 module : this.getModules()) {
            if (!context.hasContext(module.toString(), this.klass)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public Class<T> getSubTarget() {
        return this.klass;
    }
}

