/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.api.module;

import com.google.common.base.Preconditions;
import io.sc3.plethora.api.method.BasicMethod;
import io.sc3.plethora.api.method.IPartialContext;
import io.sc3.plethora.api.module.IModuleContainer;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.class_2960;

public abstract class ModuleContainerMethod
extends BasicMethod<IModuleContainer> {
    private final Set<class_2960> modules;

    public ModuleContainerMethod(String name, Set<class_2960> modules, int priority, String doc) {
        super(name, priority, doc);
        Preconditions.checkArgument((!modules.isEmpty() ? 1 : 0) != 0, (Object)"modules must be non-empty");
        this.modules = modules;
    }

    @Override
    public boolean canApply(@Nonnull IPartialContext<IModuleContainer> context) {
        if (!super.canApply(context)) {
            return false;
        }
        IModuleContainer container = context.getTarget();
        for (class_2960 module : this.modules) {
            if (container.hasModule(module)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public Collection<class_2960> getModules() {
        return this.modules;
    }
}

