/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.api.module;

import io.sc3.plethora.api.module.IModuleContainer;
import io.sc3.plethora.api.reference.IReference;
import io.sc3.plethora.api.reference.Reference;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.class_2960;

public class BasicModuleContainer
implements IModuleContainer {
    public static final IModuleContainer EMPTY = new BasicModuleContainer(Collections.emptySet());
    public static final IReference<IModuleContainer> EMPTY_REF = Reference.id(EMPTY);
    private final Set<class_2960> modules;

    public BasicModuleContainer(@Nonnull Set<class_2960> modules) {
        Objects.requireNonNull(modules, "modules cannot be null");
        this.modules = Collections.unmodifiableSet(modules);
    }

    @Override
    public boolean hasModule(@Nonnull class_2960 module) {
        return this.modules.contains(module);
    }

    @Override
    @Nonnull
    public Set<class_2960> getModules() {
        return this.modules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicModuleContainer that = (BasicModuleContainer)o;
        return this.modules.equals(that.modules);
    }

    public int hashCode() {
        return this.modules.hashCode();
    }
}

