/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.api.method;

import dan200.computercraft.api.lua.MethodResult;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;

public final class FutureMethodResult {
    private static final FutureMethodResult empty = new FutureMethodResult(MethodResult.of());
    private final MethodResult result;
    private final Callable<FutureMethodResult> next;
    private final Resolver resolver;
    private static final Resolver IMMEDIATE = () -> true;

    private FutureMethodResult(MethodResult result) {
        this.result = result;
        this.next = null;
        this.resolver = IMMEDIATE;
    }

    private FutureMethodResult(Callable<FutureMethodResult> next, Resolver resolver) {
        Objects.requireNonNull(next, "next cannot be null");
        Objects.requireNonNull(resolver, "resolver cannot be null");
        this.result = null;
        this.next = next;
        this.resolver = resolver;
    }

    public boolean isFinal() {
        return this.next == null;
    }

    public MethodResult getResult() {
        if (!this.isFinal()) {
            throw new IllegalStateException("FutureMethodResult is a callback");
        }
        return this.result;
    }

    public Callable<FutureMethodResult> getCallback() {
        if (this.isFinal()) {
            throw new IllegalStateException("FutureMethodResult is a result");
        }
        return this.next;
    }

    public Resolver getResolver() {
        if (this.isFinal()) {
            throw new IllegalStateException("FutureMethodResult is a result");
        }
        return this.resolver;
    }

    public static FutureMethodResult nextTick(Callable<FutureMethodResult> next) {
        return new FutureMethodResult(next, IMMEDIATE);
    }

    public static FutureMethodResult nextTick(Runnable next) {
        return new FutureMethodResult(FutureMethodResult.wrap(next), IMMEDIATE);
    }

    public static FutureMethodResult delayed(int delay, Callable<FutureMethodResult> next) {
        return new FutureMethodResult(next, delay <= 0 ? IMMEDIATE : new DelayedResolver(delay));
    }

    public static FutureMethodResult awaiting(Resolver resolver, Callable<FutureMethodResult> next) {
        return new FutureMethodResult(next, resolver);
    }

    @Nonnull
    public static FutureMethodResult result(Object ... args) {
        return new FutureMethodResult(MethodResult.of((Object[])args));
    }

    @Nonnull
    public static FutureMethodResult result(Object arg) {
        return new FutureMethodResult(MethodResult.of((Object)arg));
    }

    @Nonnull
    public static FutureMethodResult failure(String message) {
        return new FutureMethodResult(MethodResult.of((Object[])new Object[]{false, message}));
    }

    @Nonnull
    public static FutureMethodResult empty() {
        return empty;
    }

    private static Callable<FutureMethodResult> wrap(Runnable runnable) {
        return () -> {
            runnable.run();
            return empty;
        };
    }

    @FunctionalInterface
    public static interface Resolver {
        public boolean update();
    }

    private static class DelayedResolver
    implements Resolver {
        private int remaining;

        DelayedResolver(int remaining) {
            this.remaining = remaining;
        }

        @Override
        public boolean update() {
            return this.remaining-- == 0;
        }
    }
}

