/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.api.method;

import com.google.common.base.Strings;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import io.sc3.plethora.api.method.FutureMethodResult;
import io.sc3.plethora.api.method.IMethod;
import io.sc3.plethora.api.method.IPartialContext;
import io.sc3.plethora.api.method.IUnbakedContext;
import javax.annotation.Nonnull;

public abstract class BasicMethod<T>
implements IMethod<T> {
    private final String name;
    private final String docs;
    private final int priority;

    public BasicMethod(String name, String docs) {
        this(name, 0, docs);
    }

    public BasicMethod(String name, int priority, String docs) {
        this.name = name;
        this.priority = priority;
        this.docs = Strings.isNullOrEmpty((String)docs) ? null : docs;
    }

    @Nonnull
    public static <T> BasicMethod<T> of(String name, String docs, final IMethod.Delegate<T> delegate, final boolean worldThread) {
        return new BasicMethod<T>(name, docs){

            @Override
            @Nonnull
            public FutureMethodResult apply(@Nonnull IUnbakedContext<T> context, @Nonnull IArguments args) throws LuaException {
                return worldThread ? FutureMethodResult.nextTick(() -> delegate.apply(context, args)) : delegate.apply(context, args);
            }
        };
    }

    public static <T> BasicMethod<T> of(String name, String docs, IMethod.Delegate<T> delegate) {
        return BasicMethod.of(name, docs, delegate, true);
    }

    @Nonnull
    public static <T> BasicMethod<T> alias(final BasicMethod<T> method, String name) {
        return new BasicMethod<T>(name, method.getPriority(), method.getDocString()){

            @Override
            @Nonnull
            public FutureMethodResult apply(@Nonnull IUnbakedContext<T> context, @Nonnull IArguments args) throws LuaException {
                return method.apply(context, args);
            }
        };
    }

    @Override
    @Nonnull
    public final String getName() {
        return this.name;
    }

    @Override
    public boolean canApply(@Nonnull IPartialContext<T> context) {
        return true;
    }

    @Override
    public final int getPriority() {
        return this.priority;
    }

    @Override
    @Nonnull
    public String getDocString() {
        return this.docs;
    }
}

